/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.relational.ValueContainer;

public class Table
extends AbstractTableSpecification
implements ValueContainer,
Exportable {
    private final ObjectName name;
    private final Set<ObjectName> spaces;
    private List<Index> indexes;
    private List<UniqueKey> uniqueKeys;

    public Table(ObjectName name) {
        this.name = name;
        this.spaces = Collections.singleton(name);
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.getObjectName().getIdentifier();
    }

    @Override
    public String getExportIdentifier() {
        return this.getObjectName().getIdentifier();
    }

    @Override
    public Iterable<ObjectName> getSpaces() {
        return this.spaces;
    }

    @Override
    public String toLoggableString() {
        return this.getObjectName().getIdentifier();
    }

    public Index createIndex(String name) {
        Index index = new Index(this, name);
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        this.indexes.add(index);
        return index;
    }

    public UniqueKey createUniqueKey(String name) {
        UniqueKey uniqueKey = new UniqueKey(this, name);
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new ArrayList<UniqueKey>();
        }
        this.uniqueKeys.add(uniqueKey);
        return uniqueKey;
    }

    public String toString() {
        return "Table{name=" + this.getObjectName().getIdentifier() + '}';
    }
}

