/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.IllegalIdentifierException;

public class ObjectName {
    private final Identifier schema;
    private final Identifier catalog;
    private final Identifier name;
    private final String identifier;
    private final int hashCode;

    public ObjectName(Identifier name) {
        this(null, null, name);
    }

    public ObjectName(String schemaName, String catalogName, String name) {
        this(Identifier.toIdentifier(schemaName), Identifier.toIdentifier(catalogName), Identifier.toIdentifier(name));
    }

    public ObjectName(Identifier schema, Identifier catalog, Identifier name) {
        if (name == null) {
            throw new IllegalIdentifierException("Object name must be specified");
        }
        this.name = name;
        this.schema = schema;
        this.catalog = catalog;
        StringBuilder buff = new StringBuilder(name.toString());
        if (catalog != null) {
            buff.insert(0, catalog.toString() + '.');
        }
        if (schema != null) {
            buff.insert(0, schema.toString() + '.');
        }
        this.identifier = buff.toString();
        int tmpHashCode = schema != null ? schema.hashCode() : 0;
        tmpHashCode = 31 * tmpHashCode + (catalog != null ? catalog.hashCode() : 0);
        this.hashCode = tmpHashCode = 31 * tmpHashCode + name.hashCode();
    }

    public Identifier getSchema() {
        return this.schema;
    }

    public Identifier getCatalog() {
        return this.catalog;
    }

    public Identifier getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectName that = (ObjectName)o;
        return this.name.equals(that.name) && this.areEqual(this.catalog, that.catalog) && this.areEqual(this.schema, that.schema);
    }

    private boolean areEqual(Identifier one, Identifier other) {
        return one == null ? other == null : one.equals(other);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ObjectName{name='" + this.name + '\'' + ", schema='" + this.schema + '\'' + ", catalog='" + this.catalog + '\'' + '}';
    }
}

