/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.ValueContainer;

public class InLineView
extends AbstractTableSpecification
implements ValueContainer {
    private final String select;
    private final String uniqueValueQualifier;
    private Set<ObjectName> synchronizedTableSpaces = Collections.emptySet();

    public InLineView(String select, String uniqueValueQualifier) {
        this.select = select;
        this.uniqueValueQualifier = uniqueValueQualifier;
    }

    public String getSelect() {
        return this.select;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.uniqueValueQualifier;
    }

    public void addSynchronizedTable(String tableName) {
        this.addSynchronizedTable(new ObjectName(null, null, tableName));
    }

    public void addSynchronizedTable(ObjectName tableName) {
        if (this.synchronizedTableSpaces.isEmpty()) {
            this.synchronizedTableSpaces = new HashSet<ObjectName>();
        }
        this.synchronizedTableSpaces.add(tableName);
    }

    public Set<ObjectName> getSpaces() {
        return this.synchronizedTableSpaces;
    }

    @Override
    public String toLoggableString() {
        return "{inline-view}";
    }
}

