/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.logical;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.metamodel.logical.Attribute;
import org.hibernate.metamodel.logical.AttributeContainer;
import org.hibernate.metamodel.logical.Hierarchical;

public abstract class AbstractAttributeContainer
implements AttributeContainer,
Hierarchical {
    private final String name;
    private final Hierarchical superType;
    private LinkedHashSet<Attribute> attributeSet = new LinkedHashSet();
    private HashMap<String, Attribute> attributeMap = new HashMap();

    public AbstractAttributeContainer(String name, Hierarchical superType) {
        this.name = name;
        this.superType = superType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Hierarchical getSuperType() {
        return this.superType;
    }

    @Override
    public Set<Attribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributeSet);
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public void addAttribute(Attribute attribute) {
        if (this.attributeMap.put(attribute.getName(), attribute) != null) {
            throw new IllegalArgumentException("Attrtibute with name [" + attribute.getName() + "] already registered");
        }
        this.attributeSet.add(attribute);
    }
}

