/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OneToMany
implements Value {
    private final Mappings mappings;
    private final Table referencingTable;
    private String referencedEntityName;
    private PersistentClass associatedClass;
    private boolean embedded;
    private boolean ignoreNotFound;

    private EntityType getEntityType() {
        return this.mappings.getTypeResolver().getTypeFactory().manyToOne(this.getReferencedEntityName(), null, false, false, this.isEmbedded(), this.isIgnoreNotFound(), false);
    }

    public OneToMany(Mappings mappings, PersistentClass owner) throws MappingException {
        this.mappings = mappings;
        this.referencingTable = owner == null ? null : owner.getTable();
    }

    public PersistentClass getAssociatedClass() {
        return this.associatedClass;
    }

    public void setAssociatedClass(PersistentClass associatedClass) {
        this.associatedClass = associatedClass;
    }

    @Override
    public void createForeignKey() {
    }

    @Override
    public Iterator getColumnIterator() {
        return this.associatedClass.getKey().getColumnIterator();
    }

    @Override
    public int getColumnSpan() {
        return this.associatedClass.getKey().getColumnSpan();
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.JOIN;
    }

    @Override
    public Table getTable() {
        return this.referencingTable;
    }

    @Override
    public Type getType() {
        return this.getEntityType();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSimpleValue() {
        return false;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return false;
    }

    @Override
    public boolean hasFormula() {
        return false;
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("one to many association must specify the referenced entity");
        }
        return true;
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean[] getColumnInsertability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getColumnUpdateability() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }
}

