/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public abstract class Constraint
implements RelationalModel,
Serializable {
    private String name;
    private final List columns = new ArrayList();
    private Table table;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator columnIterator) {
        while (columnIterator.hasNext()) {
            Selectable col = (Selectable)columnIterator.next();
            if (col.isFormula()) continue;
            this.addColumn((Column)col);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Column getColumn(int i) {
        return (Column)this.columns.get(i);
    }

    public Iterator columnIterator() {
        return this.columns.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isGenerated(Dialect dialect) {
        return true;
    }

    @Override
    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        if (this.isGenerated(dialect)) {
            return new StringBuffer().append("alter table ").append(this.getTable().getQualifiedName(dialect, defaultCatalog, defaultSchema)).append(" drop constraint ").append(dialect.quote(this.getName())).toString();
        }
        return null;
    }

    @Override
    public String sqlCreateString(Dialect dialect, Mapping p, String defaultCatalog, String defaultSchema) {
        if (this.isGenerated(dialect)) {
            String constraintString = this.sqlConstraintString(dialect, this.getName(), defaultCatalog, defaultSchema);
            StringBuffer buf = new StringBuffer("alter table ").append(this.getTable().getQualifiedName(dialect, defaultCatalog, defaultSchema)).append(constraintString);
            return buf.toString();
        }
        return null;
    }

    public List getColumns() {
        return this.columns;
    }

    public abstract String sqlConstraintString(Dialect var1, String var2, String var3, String var4);

    public String toString() {
        return this.getClass().getName() + '(' + this.getTable().getName() + this.getColumns() + ") as " + this.name;
    }
}

