/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.OutputStream;
import java.util.List;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.xml.DTDEntityResolver;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)XMLHelper.class.getName());
    public static final EntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
    private DOMReader domReader;
    private SAXReader saxReader;

    public SAXReader createSAXReader(String file, List errorsList, EntityResolver entityResolver) {
        SAXReader saxReader = this.resolveSAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(file, errorsList));
        return saxReader;
    }

    private SAXReader resolveSAXReader() {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
            this.saxReader.setMergeAdjacentText(true);
            this.saxReader.setValidation(true);
        }
        return this.saxReader;
    }

    public DOMReader createDOMReader() {
        if (this.domReader == null) {
            this.domReader = new DOMReader();
        }
        return this.domReader;
    }

    public static Element generateDom4jElement(String elementName) {
        return DocumentFactory.getInstance().createElement(elementName);
    }

    public static void dump(Element element) {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)System.out, outformat);
            writer.write(element);
            writer.flush();
            System.out.println("");
        }
        catch (Throwable t) {
            System.out.println(element.asXML());
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List<SAXParseException> errors;

        private ErrorLogger(String file, List errors) {
            this.file = file;
            this.errors = errors;
        }

        @Override
        public void error(SAXParseException error) {
            LOG.parsingXmlErrorForFile(this.file, error.getLineNumber(), error.getMessage());
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        @Override
        public void warning(SAXParseException warn) {
            LOG.parsingXmlWarningForFile(this.file, warn.getLineNumber(), warn.getMessage());
        }
    }
}

