/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.hibernate.HibernateLogger;
import org.hibernate.InvalidMappingException;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.internal.util.xml.Origin;
import org.hibernate.internal.util.xml.XmlDocument;
import org.hibernate.internal.util.xml.XmlDocumentImpl;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingReader {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)MappingReader.class.getName());
    public static final String ASSUMED_ORM_XSD_VERSION = "2.0";
    public static final MappingReader INSTANCE = new MappingReader();

    private MappingReader() {
    }

    public XmlDocument readMappingDocument(EntityResolver entityResolver, InputSource source, Origin origin) {
        ErrorLogger errorHandler = new ErrorLogger();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler((ErrorHandler)errorHandler);
        saxReader.setMergeAdjacentText(true);
        saxReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(saxReader, "orm_2_0.xsd");
            document = saxReader.read(source);
            if (errorHandler.getError() != null) {
                throw errorHandler.getError();
            }
            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
        }
        catch (Exception orm2Problem) {
            LOG.debugf("Problem parsing XML using orm 2 xsd : %s", orm2Problem.getMessage());
            Exception failure = orm2Problem;
            errorHandler.reset();
            if (document != null) {
                try {
                    this.setValidationFor(saxReader, "orm_1_0.xsd");
                    document = saxReader.read((Reader)new StringReader(document.asXML()));
                    if (errorHandler.getError() != null) {
                        throw errorHandler.getError();
                    }
                    return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                }
                catch (Exception orm1Problem) {
                    LOG.debugf("Problem parsing XML using orm 1 xsd : %s", orm1Problem.getMessage());
                }
            }
            throw new InvalidMappingException("Unable to read XML", origin.getType(), origin.getName(), failure);
        }
    }

    private void setValidationFor(SAXReader saxReader, String xsd) {
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://java.sun.com/xml/ns/persistence/orm " + xsd));
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
    }
}

