/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.xml;

import java.io.Serializable;
import org.hibernate.HibernateLogger;
import org.jboss.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ErrorLogger
implements ErrorHandler,
Serializable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)ErrorLogger.class.getName());
    private SAXParseException error;

    public SAXParseException getError() {
        return this.error;
    }

    @Override
    public void error(SAXParseException error) {
        LOG.parsingXmlError(error.getLineNumber(), error.getMessage());
        if (this.error == null) {
            this.error = error;
        }
    }

    @Override
    public void fatalError(SAXParseException error) {
        this.error(error);
    }

    @Override
    public void warning(SAXParseException warn) {
        LOG.parsingXmlWarning(this.error.getLineNumber(), this.error.getMessage());
    }

    public void reset() {
        this.error = null;
    }
}

