/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.MappingException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class AbstractScrollableResults
implements ScrollableResults {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)AbstractScrollableResults.class.getName());
    private final ResultSet resultSet;
    private final PreparedStatement ps;
    private final SessionImplementor session;
    private final Loader loader;
    private final QueryParameters queryParameters;
    private final Type[] types;
    private HolderInstantiator holderInstantiator;

    public AbstractScrollableResults(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Loader loader, QueryParameters queryParameters, Type[] types, HolderInstantiator holderInstantiator) throws MappingException {
        this.resultSet = rs;
        this.ps = ps;
        this.session = sess;
        this.loader = loader;
        this.queryParameters = queryParameters;
        this.types = types;
        this.holderInstantiator = holderInstantiator != null && holderInstantiator.isRequired() ? holderInstantiator : null;
    }

    protected abstract Object[] getCurrentRow();

    protected ResultSet getResultSet() {
        return this.resultSet;
    }

    protected PreparedStatement getPs() {
        return this.ps;
    }

    protected SessionImplementor getSession() {
        return this.session;
    }

    protected Loader getLoader() {
        return this.loader;
    }

    protected QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    protected Type[] getTypes() {
        return this.types;
    }

    protected HolderInstantiator getHolderInstantiator() {
        return this.holderInstantiator;
    }

    @Override
    public final void close() throws HibernateException {
        try {
            this.ps.close();
        }
        catch (SQLException sqle) {
            throw this.session.getFactory().getSQLExceptionHelper().convert(sqle, "could not close results");
        }
        finally {
            try {
                this.session.getPersistenceContext().getLoadContexts().cleanup(this.resultSet);
            }
            catch (Throwable ignore) {
                LOG.trace("Exception trying to cleanup load context : " + ignore.getMessage());
            }
        }
    }

    @Override
    public final Object[] get() throws HibernateException {
        return this.getCurrentRow();
    }

    @Override
    public final Object get(int col) throws HibernateException {
        return this.getCurrentRow()[col];
    }

    protected final Object getFinal(int col, Type returnType) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass() == this.types[col].getReturnedClass()) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    protected final Object getNonFinal(int col, Type returnType) throws HibernateException {
        if (this.holderInstantiator != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass().isAssignableFrom(this.types[col].getReturnedClass())) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    @Override
    public final BigDecimal getBigDecimal(int col) throws HibernateException {
        return (BigDecimal)this.getFinal(col, Hibernate.BIG_DECIMAL);
    }

    @Override
    public final BigInteger getBigInteger(int col) throws HibernateException {
        return (BigInteger)this.getFinal(col, Hibernate.BIG_INTEGER);
    }

    @Override
    public final byte[] getBinary(int col) throws HibernateException {
        return (byte[])this.getFinal(col, Hibernate.BINARY);
    }

    @Override
    public final String getText(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.TEXT);
    }

    @Override
    public final Blob getBlob(int col) throws HibernateException {
        return (Blob)this.getNonFinal(col, Hibernate.BLOB);
    }

    @Override
    public final Clob getClob(int col) throws HibernateException {
        return (Clob)this.getNonFinal(col, Hibernate.CLOB);
    }

    @Override
    public final Boolean getBoolean(int col) throws HibernateException {
        return (Boolean)this.getFinal(col, Hibernate.BOOLEAN);
    }

    @Override
    public final Byte getByte(int col) throws HibernateException {
        return (Byte)this.getFinal(col, Hibernate.BYTE);
    }

    @Override
    public final Character getCharacter(int col) throws HibernateException {
        return (Character)this.getFinal(col, Hibernate.CHARACTER);
    }

    @Override
    public final Date getDate(int col) throws HibernateException {
        return (Date)this.getNonFinal(col, Hibernate.TIMESTAMP);
    }

    @Override
    public final Calendar getCalendar(int col) throws HibernateException {
        return (Calendar)this.getNonFinal(col, Hibernate.CALENDAR);
    }

    @Override
    public final Double getDouble(int col) throws HibernateException {
        return (Double)this.getFinal(col, Hibernate.DOUBLE);
    }

    @Override
    public final Float getFloat(int col) throws HibernateException {
        return (Float)this.getFinal(col, Hibernate.FLOAT);
    }

    @Override
    public final Integer getInteger(int col) throws HibernateException {
        return (Integer)this.getFinal(col, Hibernate.INTEGER);
    }

    @Override
    public final Long getLong(int col) throws HibernateException {
        return (Long)this.getFinal(col, Hibernate.LONG);
    }

    @Override
    public final Short getShort(int col) throws HibernateException {
        return (Short)this.getFinal(col, Hibernate.SHORT);
    }

    @Override
    public final String getString(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.STRING);
    }

    @Override
    public final Locale getLocale(int col) throws HibernateException {
        return (Locale)this.getFinal(col, Hibernate.LOCALE);
    }

    @Override
    public final TimeZone getTimeZone(int col) throws HibernateException {
        return (TimeZone)this.getNonFinal(col, Hibernate.TIMEZONE);
    }

    @Override
    public final Type getType(int i) {
        return this.types[i];
    }

    private Object throwInvalidColumnTypeException(int i, Type type, Type returnType) throws HibernateException {
        throw new HibernateException("incompatible column types: " + type.getName() + ", " + returnType.getName());
    }

    protected void afterScrollOperation() {
        this.session.afterScrollOperation();
    }
}

