/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;
import org.jboss.logging.Logger;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)DefaultDirtyCheckEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDirtyCheck(DirtyCheckEvent event) throws HibernateException {
        int oldSize = event.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(event);
            boolean wasNeeded = event.getSession().getActionQueue().hasAnyQueuedActions();
            if (wasNeeded) {
                LOG.debugf("Session dirty", new Object[0]);
            } else {
                LOG.debugf("Session not dirty", new Object[0]);
            }
            event.setDirty(wasNeeded);
        }
        finally {
            event.getSession().getActionQueue().clearFromFlushNeededCheck(oldSize);
        }
    }
}

