/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateLogger;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)AbstractLockUpgradeEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        SoftLock lock;
        CacheKey ck;
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locking " + MessageHelper.infoString(persister, entry.getId(), source.getFactory()) + " in mode: " + requestedLockMode);
        }
        if (persister.hasCache()) {
            ck = new CacheKey(entry.getId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode(), source.getFactory());
            lock = persister.getCacheAccessStrategy().lockItem(ck, entry.getVersion());
        } else {
            ck = null;
            lock = null;
        }
        try {
            if (persister.isVersioned() && requestedLockMode == LockMode.FORCE) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), source);
                entry.forceLocked(object, nextVersion);
            } else {
                persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, (SessionImplementor)source);
            }
            entry.setLockMode(requestedLockMode);
            if (!persister.hasCache()) return;
        }
        catch (Throwable throwable) {
            if (!persister.hasCache()) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(ck, lock);
    }
}

