/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.synchronization.internal;

import javax.transaction.SystemException;
import org.hibernate.HibernateLogger;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.synchronization.spi.AfterCompletionAction;
import org.hibernate.engine.transaction.synchronization.spi.ExceptionMapper;
import org.hibernate.engine.transaction.synchronization.spi.ManagedFlushChecker;
import org.hibernate.engine.transaction.synchronization.spi.SynchronizationCallbackCoordinator;
import org.jboss.logging.Logger;

public class SynchronizationCallbackCoordinatorImpl
implements SynchronizationCallbackCoordinator {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)SynchronizationCallbackCoordinatorImpl.class.getName());
    private final TransactionCoordinator transactionCoordinator;
    private ManagedFlushChecker managedFlushChecker;
    private AfterCompletionAction afterCompletionAction;
    private ExceptionMapper exceptionMapper;
    private static final ManagedFlushChecker STANDARD_MANAGED_FLUSH_CHECKER = new ManagedFlushChecker(){

        @Override
        public boolean shouldDoManagedFlush(TransactionCoordinator coordinator, int jtaStatus) {
            return !coordinator.getTransactionContext().isClosed() && !coordinator.getTransactionContext().isFlushModeNever() && coordinator.getTransactionContext().isFlushBeforeCompletionEnabled() && !JtaStatusHelper.isRollback(jtaStatus);
        }
    };
    private static final ExceptionMapper STANDARD_EXCEPTION_MAPPER = new ExceptionMapper(){

        @Override
        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            LOG.error(LOG.unableToDetermineTransactionStatus(), (Throwable)systemException);
            return new TransactionException("could not determine transaction status in beforeCompletion()", (Throwable)systemException);
        }

        @Override
        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            LOG.unableToPerformManagedFlush(failure.getMessage());
            return failure;
        }
    };
    private static final AfterCompletionAction STANDARD_AFTER_COMPLETION_ACTION = new AfterCompletionAction(){

        @Override
        public void doAction(TransactionCoordinator transactionCoordinator, int status) {
        }
    };

    public SynchronizationCallbackCoordinatorImpl(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.reset();
    }

    public void reset() {
        this.managedFlushChecker = STANDARD_MANAGED_FLUSH_CHECKER;
        this.exceptionMapper = STANDARD_EXCEPTION_MAPPER;
        this.afterCompletionAction = STANDARD_AFTER_COMPLETION_ACTION;
    }

    @Override
    public void setManagedFlushChecker(ManagedFlushChecker managedFlushChecker) {
        this.managedFlushChecker = managedFlushChecker;
    }

    @Override
    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public void setAfterCompletionAction(AfterCompletionAction afterCompletionAction) {
        this.afterCompletionAction = afterCompletionAction;
    }

    public void beforeCompletion() {
        boolean flush;
        LOG.trace("Transaction before completion callback");
        try {
            int status = this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().getCurrentStatus();
            flush = this.managedFlushChecker.shouldDoManagedFlush(this.transactionCoordinator, status);
        }
        catch (SystemException se) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapStatusCheckFailure("could not determine transaction status in beforeCompletion()", se);
        }
        try {
            if (flush) {
                LOG.trace("Automatically flushing session");
                this.transactionCoordinator.getTransactionContext().managedFlush();
            }
        }
        catch (RuntimeException re) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", re);
        }
        finally {
            this.transactionCoordinator.sendBeforeTransactionCompletionNotifications(null);
            this.transactionCoordinator.getTransactionContext().beforeTransactionCompletion(null);
        }
    }

    private void setRollbackOnly() {
        this.transactionCoordinator.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        LOG.trace("Transaction after completion callback [status=" + status + "]");
        try {
            this.afterCompletionAction.doAction(this.transactionCoordinator, status);
            this.transactionCoordinator.afterTransaction(null, status);
        }
        finally {
            this.reset();
            if (this.transactionContext().shouldAutoClose() && !this.transactionContext().isClosed()) {
                LOG.trace("Automatically closing session");
                this.transactionContext().managedClose();
            }
        }
    }

    private TransactionContext transactionContext() {
        return this.transactionCoordinator.getTransactionContext();
    }
}

