/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public class JtaIsolationDelegate
implements IsolationDelegate {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JtaIsolationDelegate.class.getName());
    private final TransactionCoordinator transactionCoordinator;

    public JtaIsolationDelegate(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    protected TransactionManager transactionManager() {
        return this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().retrieveTransactionManager();
    }

    protected ConnectionProvider connectionProvider() {
        return this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices().getConnectionProvider();
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public void delegateWork(Work work, boolean transacted) throws HibernateException {
        TransactionManager transactionManager = this.transactionManager();
        try {
            Transaction surroundingTransaction = transactionManager.suspend();
            LOG.debugf("Surrounding JTA transaction suspended [%s]", surroundingTransaction);
            boolean hadProblems = false;
            try {
                if (transacted) {
                    this.doTheWorkInNewTransaction(work, transactionManager);
                } else {
                    this.doTheWorkInNoTransaction(work);
                }
            }
            catch (HibernateException e) {
                hadProblems = true;
                throw e;
            }
            finally {
                block14: {
                    try {
                        transactionManager.resume(surroundingTransaction);
                        LOG.debugf("Surrounding JTA transaction resumed [%s]", surroundingTransaction);
                    }
                    catch (Throwable t) {
                        if (hadProblems) break block14;
                        throw new HibernateException("Unable to resume previously suspended transaction", t);
                    }
                }
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to suspend current JTA transaction", e);
        }
    }

    private void doTheWorkInNewTransaction(Work work, TransactionManager transactionManager) {
        try {
            transactionManager.begin();
            try {
                this.doTheWork(work);
                transactionManager.commit();
            }
            catch (Exception e) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackIsolatedTransaction(e, ignore);
                }
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
        catch (NotSupportedException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
    }

    private void doTheWorkInNoTransaction(Work work) {
        this.doTheWork(work);
    }

    private void doTheWork(Work work) {
        try {
            Connection connection = this.connectionProvider().getConnection();
            try {
                work.execute(connection);
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to perform isolated work", e);
            }
            finally {
                try {
                    this.connectionProvider().closeConnection(connection);
                }
                catch (Throwable ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper().convert(sqle, "unable to obtain isolated JDBC connection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(ReturningWork<T> work, boolean transacted) throws HibernateException {
        TransactionManager transactionManager = this.transactionManager();
        try {
            Transaction surroundingTransaction = transactionManager.suspend();
            LOG.debugf("Surrounding JTA transaction suspended [%s]", surroundingTransaction);
            boolean hadProblems = false;
            try {
                if (transacted) {
                    T t = this.doTheWorkInNewTransaction(work, transactionManager);
                    return t;
                }
                T t = this.doTheWorkInNoTransaction(work);
                return t;
            }
            catch (HibernateException e) {
                hadProblems = true;
                throw e;
            }
            finally {
                block15: {
                    try {
                        transactionManager.resume(surroundingTransaction);
                        LOG.debugf("Surrounding JTA transaction resumed [%s]", surroundingTransaction);
                    }
                    catch (Throwable t) {
                        if (hadProblems) break block15;
                        throw new HibernateException("Unable to resume previously suspended transaction", t);
                    }
                }
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to suspend current JTA transaction", e);
        }
    }

    private <T> T doTheWorkInNewTransaction(ReturningWork<T> work, TransactionManager transactionManager) {
        T result = null;
        try {
            transactionManager.begin();
            try {
                result = this.doTheWork(work);
                transactionManager.commit();
            }
            catch (Exception e) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception ignore) {
                    LOG.unableToRollbackIsolatedTransaction(e, ignore);
                }
            }
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
        catch (NotSupportedException e) {
            throw new HibernateException("Unable to start isolated transaction", e);
        }
        return result;
    }

    private <T> T doTheWorkInNoTransaction(ReturningWork<T> work) {
        return this.doTheWork(work);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doTheWork(ReturningWork<T> work) {
        try {
            Connection connection = this.connectionProvider().getConnection();
            try {
                T t = work.execute(connection);
                return t;
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to perform isolated work", e);
            }
            finally {
                try {
                    this.connectionProvider().closeConnection(connection);
                }
                catch (Throwable ignore) {
                    LOG.unableToReleaseIsolatedConnection(ignore);
                }
            }
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "unable to obtain isolated JDBC connection");
        }
    }
}

