/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.JtaTransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistry;
import org.jboss.logging.Logger;

public class TransactionFactoryInitiator
implements ServiceInitiator<TransactionFactory> {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)TransactionFactoryInitiator.class.getName());
    public static final TransactionFactoryInitiator INSTANCE = new TransactionFactoryInitiator();

    @Override
    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    @Override
    public TransactionFactory initiateService(Map configVales, ServiceRegistry registry) {
        Object strategy = configVales.get("hibernate.transaction.factory_class");
        if (TransactionFactory.class.isInstance(strategy)) {
            return (TransactionFactory)strategy;
        }
        if (strategy == null) {
            LOG.usingDefaultTransactionStrategy();
            return new JdbcTransactionFactory();
        }
        String strategyClassName = this.mapLegacyNames(strategy.toString());
        LOG.transactionStrategy(strategyClassName);
        ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
        try {
            return (TransactionFactory)classLoaderService.classForName(strategyClassName).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate specified TransactionFactory class [" + strategyClassName + "]", e);
        }
    }

    private String mapLegacyNames(String name) {
        if ("org.hibernate.transaction.JDBCTransactionFactory".equals(name)) {
            return JdbcTransactionFactory.class.getName();
        }
        if ("org.hibernate.transaction.JTATransactionFactory".equals(name)) {
            return JtaTransactionFactory.class.getName();
        }
        if ("org.hibernate.transaction.CMTTransactionFactory".equals(name)) {
            return CMTTransactionFactory.class.getName();
        }
        return name;
    }
}

