/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.query.ParameterParser;
import org.hibernate.internal.util.collections.ArrayHelper;

public class ParamLocationRecognizer
implements ParameterParser.Recognizer {
    private Map namedParameterDescriptions = new HashMap();
    private List ordinalParameterLocationList = new ArrayList();

    public static ParamLocationRecognizer parseLocations(String query) {
        ParamLocationRecognizer recognizer = new ParamLocationRecognizer();
        ParameterParser.parse(query, recognizer);
        return recognizer;
    }

    public Map getNamedParameterDescriptionMap() {
        return this.namedParameterDescriptions;
    }

    public List getOrdinalParameterLocationList() {
        return this.ordinalParameterLocationList;
    }

    @Override
    public void ordinalParameter(int position) {
        this.ordinalParameterLocationList.add(new Integer(position));
    }

    @Override
    public void namedParameter(String name, int position) {
        this.getOrBuildNamedParameterDescription(name, false).add(position);
    }

    @Override
    public void jpaPositionalParameter(String name, int position) {
        this.getOrBuildNamedParameterDescription(name, true).add(position);
    }

    private NamedParameterDescription getOrBuildNamedParameterDescription(String name, boolean jpa) {
        NamedParameterDescription desc = (NamedParameterDescription)this.namedParameterDescriptions.get(name);
        if (desc == null) {
            desc = new NamedParameterDescription(jpa);
            this.namedParameterDescriptions.put(name, desc);
        }
        return desc;
    }

    @Override
    public void other(char character) {
    }

    @Override
    public void outParameter(int position) {
    }

    public static class NamedParameterDescription {
        private final boolean jpaStyle;
        private final List positions = new ArrayList();

        public NamedParameterDescription(boolean jpaStyle) {
            this.jpaStyle = jpaStyle;
        }

        public boolean isJpaStyle() {
            return this.jpaStyle;
        }

        private void add(int position) {
            this.positions.add(new Integer(position));
        }

        public int[] buildPositionsArray() {
            return ArrayHelper.toIntArray(this.positions);
        }
    }
}

