/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateLogger;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.loading.CollectionLoadContext;
import org.hibernate.engine.loading.EntityLoadContext;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class LoadContexts {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)LoadContexts.class.getName());
    private final PersistenceContext persistenceContext;
    private Map collectionLoadContexts;
    private Map entityLoadContexts;
    private Map xrefLoadingCollectionEntries;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    private EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }

    public void cleanup(ResultSet resultSet) {
        if (this.collectionLoadContexts != null) {
            CollectionLoadContext collectionLoadContext = (CollectionLoadContext)this.collectionLoadContexts.remove(resultSet);
            collectionLoadContext.cleanup();
        }
        if (this.entityLoadContexts != null) {
            EntityLoadContext entityLoadContext = (EntityLoadContext)this.entityLoadContexts.remove(resultSet);
            entityLoadContext.cleanup();
        }
    }

    public void cleanup() {
        if (this.collectionLoadContexts != null) {
            for (CollectionLoadContext collectionLoadContext : this.collectionLoadContexts.values()) {
                LOG.failSafeCollectionsCleanup(collectionLoadContext);
                collectionLoadContext.cleanup();
            }
            this.collectionLoadContexts.clear();
        }
        if (this.entityLoadContexts != null) {
            for (EntityLoadContext entityLoadContext : this.entityLoadContexts.values()) {
                LOG.failSafeEntitiesCleanup(entityLoadContext);
                entityLoadContext.cleanup();
            }
            this.entityLoadContexts.clear();
        }
    }

    public boolean hasLoadingCollectionEntries() {
        return this.collectionLoadContexts != null && !this.collectionLoadContexts.isEmpty();
    }

    public boolean hasRegisteredLoadingCollectionEntries() {
        return this.xrefLoadingCollectionEntries != null && !this.xrefLoadingCollectionEntries.isEmpty();
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext context = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (CollectionLoadContext)this.collectionLoadContexts.get(resultSet);
        }
        if (context == null) {
            LOG.trace("Constructing collection load context for result set [" + resultSet + "]");
            context = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, context);
        }
        return context;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister persister, Serializable ownerKey) {
        LoadingCollectionEntry lce = this.locateLoadingCollectionEntry(new CollectionKey(persister, ownerKey, this.getEntityMode()));
        if (lce != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Returning loading collection: " + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory()));
            }
            return lce.getCollection();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating collection wrapper: " + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory()));
        }
        return null;
    }

    void registerLoadingCollectionXRef(CollectionKey entryKey, LoadingCollectionEntry entry) {
        if (this.xrefLoadingCollectionEntries == null) {
            this.xrefLoadingCollectionEntries = new HashMap();
        }
        this.xrefLoadingCollectionEntries.put(entryKey, entry);
    }

    void unregisterLoadingCollectionXRef(CollectionKey key) {
        if (!this.hasRegisteredLoadingCollectionEntries()) {
            return;
        }
        this.xrefLoadingCollectionEntries.remove(key);
    }

    Map getLoadingCollectionXRefs() {
        return this.xrefLoadingCollectionEntries;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey key) {
        if (this.xrefLoadingCollectionEntries == null) {
            return null;
        }
        LOG.trace("Attempting to locate loading collection entry [" + key + "] in any result-set context");
        LoadingCollectionEntry rtn = (LoadingCollectionEntry)this.xrefLoadingCollectionEntries.get(key);
        if (rtn == null) {
            LOG.trace("Collection [" + key + "] not located in load context");
        } else {
            LOG.trace("Collection [" + key + "] located in load context");
        }
        return rtn;
    }

    void cleanupCollectionXRefs(Set entryKeys) {
        for (CollectionKey entryKey : entryKeys) {
            this.xrefLoadingCollectionEntries.remove(entryKey);
        }
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext context = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (EntityLoadContext)this.entityLoadContexts.get(resultSet);
        }
        if (context == null) {
            context = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, context);
        }
        return context;
    }
}

