/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateLogger;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.internal.LobCreatorBuilder;
import org.hibernate.engine.jdbc.internal.ResultSetWrapperImpl;
import org.hibernate.engine.jdbc.internal.TypeInfo;
import org.hibernate.engine.jdbc.internal.TypeInfoExtracter;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.ResultSetWrapper;
import org.hibernate.engine.jdbc.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.InjectService;
import org.jboss.logging.Logger;

public class JdbcServicesImpl
implements JdbcServices,
Configurable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JdbcServicesImpl.class.getName());
    private ConnectionProvider connectionProvider;
    private DialectFactory dialectFactory;
    private Dialect dialect;
    private SqlStatementLogger sqlStatementLogger;
    private SqlExceptionHelper sqlExceptionHelper;
    private ExtractedDatabaseMetaData extractedMetaDataSupport;
    private LobCreatorBuilder lobCreatorBuilder;
    public static final String SCHEMA_NAME_RESOLVER = "hibernate.schema_name_resolver";

    @InjectService
    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @InjectService
    public void setDialectFactory(DialectFactory dialectFactory) {
        this.dialectFactory = dialectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Map configValues) {
        Dialect dialect = null;
        LobCreatorBuilder lobCreatorBuilder = null;
        boolean metaSupportsScrollable = false;
        boolean metaSupportsGetGeneratedKeys = false;
        boolean metaSupportsBatchUpdates = false;
        boolean metaReportsDDLCausesTxnCommit = false;
        boolean metaReportsDDLInTxnSupported = true;
        String extraKeywordsString = "";
        int sqlStateType = -1;
        boolean lobLocatorUpdateCopy = false;
        String catalogName = null;
        String schemaName = null;
        LinkedHashSet<TypeInfo> typeInfoSet = new LinkedHashSet<TypeInfo>();
        boolean useJdbcMetadata = ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", configValues, true);
        if (useJdbcMetadata) {
            try {
                Connection conn = this.connectionProvider.getConnection();
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    LOG.database(meta.getDatabaseProductName(), meta.getDatabaseProductVersion(), meta.getDatabaseMajorVersion(), meta.getDatabaseMinorVersion());
                    LOG.driver(meta.getDriverName(), meta.getDriverVersion(), meta.getDriverMajorVersion(), meta.getDriverMinorVersion());
                    LOG.jdbcVersion(meta.getJDBCMajorVersion(), meta.getJDBCMinorVersion());
                    metaSupportsScrollable = meta.supportsResultSetType(1004);
                    metaSupportsBatchUpdates = meta.supportsBatchUpdates();
                    metaReportsDDLCausesTxnCommit = meta.dataDefinitionCausesTransactionCommit();
                    metaReportsDDLInTxnSupported = !meta.dataDefinitionIgnoredInTransactions();
                    metaSupportsGetGeneratedKeys = meta.supportsGetGeneratedKeys();
                    extraKeywordsString = meta.getSQLKeywords();
                    sqlStateType = meta.getSQLStateType();
                    lobLocatorUpdateCopy = meta.locatorsUpdateCopy();
                    typeInfoSet.addAll(TypeInfoExtracter.extractTypeInfo(meta));
                    dialect = this.dialectFactory.buildDialect(configValues, conn);
                    catalogName = conn.getCatalog();
                    SchemaNameResolver schemaNameResolver = this.determineExplicitSchemaNameResolver(configValues);
                    if (schemaNameResolver == null) {
                        // empty if block
                    }
                    if (schemaNameResolver != null) {
                        schemaName = schemaNameResolver.resolveSchemaName(conn);
                    }
                    lobCreatorBuilder = new LobCreatorBuilder(configValues, conn);
                }
                catch (SQLException sqle) {
                    LOG.unableToObtainConnectionMetadata(sqle.getMessage());
                }
                finally {
                    this.connectionProvider.closeConnection(conn);
                }
            }
            catch (SQLException sqle) {
                LOG.unableToObtainConnectionToQueryMetadata(sqle.getMessage());
                dialect = this.dialectFactory.buildDialect(configValues, null);
            }
            catch (UnsupportedOperationException uoe) {
                dialect = this.dialectFactory.buildDialect(configValues, null);
            }
        } else {
            dialect = this.dialectFactory.buildDialect(configValues, null);
        }
        boolean showSQL = ConfigurationHelper.getBoolean("hibernate.show_sql", configValues, false);
        boolean formatSQL = ConfigurationHelper.getBoolean("hibernate.format_sql", configValues, false);
        this.dialect = dialect;
        this.lobCreatorBuilder = lobCreatorBuilder == null ? new LobCreatorBuilder(configValues, null) : lobCreatorBuilder;
        this.sqlStatementLogger = new SqlStatementLogger(showSQL, formatSQL);
        this.sqlExceptionHelper = new SqlExceptionHelper(dialect.buildSQLExceptionConverter());
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(metaSupportsScrollable, metaSupportsGetGeneratedKeys, metaSupportsBatchUpdates, metaReportsDDLInTxnSupported, metaReportsDDLCausesTxnCommit, this.parseKeywords(extraKeywordsString), this.parseSQLStateType(sqlStateType), lobLocatorUpdateCopy, schemaName, catalogName, typeInfoSet);
    }

    private SchemaNameResolver determineExplicitSchemaNameResolver(Map configValues) {
        Object setting = configValues.get(SCHEMA_NAME_RESOLVER);
        if (SchemaNameResolver.class.isInstance(setting)) {
            return (SchemaNameResolver)setting;
        }
        String resolverClassName = (String)setting;
        if (resolverClassName != null) {
            try {
                Class resolverClass = ReflectHelper.classForName(resolverClassName, this.getClass());
                return (SchemaNameResolver)ReflectHelper.getDefaultConstructor(resolverClass).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.unableToLocateConfiguredSchemaNameResolver(resolverClassName, e.toString());
            }
            catch (InvocationTargetException e) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(resolverClassName, e.getTargetException().toString());
            }
            catch (Exception e) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(resolverClassName, e.toString());
            }
        }
        return null;
    }

    private Set<String> parseKeywords(String extraKeywordsString) {
        HashSet<String> keywordSet = new HashSet<String>();
        for (String keyword : extraKeywordsString.split(",")) {
            keywordSet.add(keyword);
        }
        return keywordSet;
    }

    private ExtractedDatabaseMetaData.SQLStateType parseSQLStateType(int sqlStateType) {
        switch (sqlStateType) {
            case 2: {
                return ExtractedDatabaseMetaData.SQLStateType.SQL99;
            }
            case 1: {
                return ExtractedDatabaseMetaData.SQLStateType.XOpen;
            }
        }
        return ExtractedDatabaseMetaData.SQLStateType.UNKOWN;
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedMetaDataSupport() {
        return this.extractedMetaDataSupport;
    }

    @Override
    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        return this.lobCreatorBuilder.buildLobCreator(lobCreationContext);
    }

    @Override
    public ResultSetWrapper getResultSetWrapper() {
        return ResultSetWrapperImpl.INSTANCE;
    }

    private static class ExtractedDatabaseMetaDataImpl
    implements ExtractedDatabaseMetaData {
        private final boolean supportsScrollableResults;
        private final boolean supportsGetGeneratedKeys;
        private final boolean supportsBatchUpdates;
        private final boolean supportsDataDefinitionInTransaction;
        private final boolean doesDataDefinitionCauseTransactionCommit;
        private final Set<String> extraKeywords;
        private final ExtractedDatabaseMetaData.SQLStateType sqlStateType;
        private final boolean lobLocatorUpdateCopy;
        private final String connectionSchemaName;
        private final String connectionCatalogName;
        private final LinkedHashSet<TypeInfo> typeInfoSet;

        private ExtractedDatabaseMetaDataImpl(boolean supportsScrollableResults, boolean supportsGetGeneratedKeys, boolean supportsBatchUpdates, boolean supportsDataDefinitionInTransaction, boolean doesDataDefinitionCauseTransactionCommit, Set<String> extraKeywords, ExtractedDatabaseMetaData.SQLStateType sqlStateType, boolean lobLocatorUpdateCopy, String connectionSchemaName, String connectionCatalogName, LinkedHashSet<TypeInfo> typeInfoSet) {
            this.supportsScrollableResults = supportsScrollableResults;
            this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
            this.supportsBatchUpdates = supportsBatchUpdates;
            this.supportsDataDefinitionInTransaction = supportsDataDefinitionInTransaction;
            this.doesDataDefinitionCauseTransactionCommit = doesDataDefinitionCauseTransactionCommit;
            this.extraKeywords = extraKeywords;
            this.sqlStateType = sqlStateType;
            this.lobLocatorUpdateCopy = lobLocatorUpdateCopy;
            this.connectionSchemaName = connectionSchemaName;
            this.connectionCatalogName = connectionCatalogName;
            this.typeInfoSet = typeInfoSet;
        }

        @Override
        public boolean supportsScrollableResults() {
            return this.supportsScrollableResults;
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return this.supportsGetGeneratedKeys;
        }

        @Override
        public boolean supportsBatchUpdates() {
            return this.supportsBatchUpdates;
        }

        @Override
        public boolean supportsDataDefinitionInTransaction() {
            return this.supportsDataDefinitionInTransaction;
        }

        @Override
        public boolean doesDataDefinitionCauseTransactionCommit() {
            return this.doesDataDefinitionCauseTransactionCommit;
        }

        @Override
        public Set<String> getExtraKeywords() {
            return this.extraKeywords;
        }

        @Override
        public ExtractedDatabaseMetaData.SQLStateType getSqlStateType() {
            return this.sqlStateType;
        }

        @Override
        public boolean doesLobLocatorUpdateCopy() {
            return this.lobLocatorUpdateCopy;
        }

        @Override
        public String getConnectionSchemaName() {
            return this.connectionSchemaName;
        }

        @Override
        public String getConnectionCatalogName() {
            return this.connectionCatalogName;
        }

        @Override
        public LinkedHashSet<TypeInfo> getTypeInfoSet() {
            return this.typeInfoSet;
        }
    }
}

