/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.HibernateLogger;
import org.jboss.logging.Logger;

public class IdentifierValue {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)IdentifierValue.class.getName());
    private final Serializable value;
    public static final IdentifierValue ANY = new IdentifierValue(){

        @Override
        public final Boolean isUnsaved(Serializable id) {
            LOG.trace("ID unsaved-value strategy ANY");
            return Boolean.TRUE;
        }

        @Override
        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "SAVE_ANY";
        }
    };
    public static final IdentifierValue NONE = new IdentifierValue(){

        @Override
        public final Boolean isUnsaved(Serializable id) {
            LOG.trace("ID unsaved-value strategy NONE");
            return Boolean.FALSE;
        }

        @Override
        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "SAVE_NONE";
        }
    };
    public static final IdentifierValue NULL = new IdentifierValue(){

        @Override
        public final Boolean isUnsaved(Serializable id) {
            LOG.trace("ID unsaved-value strategy NULL");
            return id == null ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "SAVE_NULL";
        }
    };
    public static final IdentifierValue UNDEFINED = new IdentifierValue(){

        @Override
        public final Boolean isUnsaved(Serializable id) {
            LOG.trace("ID unsaved-value strategy UNDEFINED");
            return null;
        }

        @Override
        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "UNDEFINED";
        }
    };

    protected IdentifierValue() {
        this.value = null;
    }

    public IdentifierValue(Serializable value) {
        this.value = value;
    }

    public Boolean isUnsaved(Serializable id) {
        LOG.trace("ID unsaved-value: " + this.value);
        return id == null || id.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Serializable getDefaultValue(Serializable currentValue) {
        return this.value;
    }

    public String toString() {
        return "identifier unsaved-value: " + this.value;
    }
}

