/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public final class Collections {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)Collections.class.getName());

    private Collections() {
    }

    public static void processUnreachableCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        if (coll.getOwner() == null) {
            Collections.processNeverReferencedCollection(coll, session);
        } else {
            Collections.processDereferencedCollection(coll, session);
        }
    }

    private static void processDereferencedCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        boolean hasOrphanDelete;
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        CollectionPersister loadedPersister = entry.getLoadedPersister();
        if (LOG.isDebugEnabled() && loadedPersister != null) {
            LOG.debugf("Collection dereferenced: %s", MessageHelper.collectionInfoString(loadedPersister, entry.getLoadedKey(), session.getFactory()));
        }
        boolean bl = hasOrphanDelete = loadedPersister != null && loadedPersister.hasOrphanDelete();
        if (hasOrphanDelete) {
            EntityKey key;
            Object owner;
            Serializable ownerId = loadedPersister.getOwnerEntityPersister().getIdentifier(coll.getOwner(), session);
            if (ownerId == null) {
                EntityEntry ownerEntry;
                if (session.getFactory().getSettings().isIdentifierRollbackEnabled() && (ownerEntry = persistenceContext.getEntry(coll.getOwner())) != null) {
                    ownerId = ownerEntry.getId();
                }
                if (ownerId == null) {
                    throw new AssertionFailure("Unable to determine collection owner identifier for orphan-delete processing");
                }
            }
            if ((owner = persistenceContext.getEntity(key = new EntityKey(ownerId, loadedPersister.getOwnerEntityPersister(), session.getEntityMode()))) == null) {
                throw new AssertionFailure("collection owner not associated with session: " + loadedPersister.getRole());
            }
            EntityEntry e = persistenceContext.getEntry(owner);
            if (e != null && e.getStatus() != Status.DELETED && e.getStatus() != Status.GONE) {
                throw new HibernateException("A collection with cascade=\"all-delete-orphan\" was no longer referenced by the owning entity instance: " + loadedPersister.getRole());
            }
        }
        entry.setCurrentPersister(null);
        entry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(coll, entry, session.getEntityMode(), session.getFactory());
    }

    private static void processNeverReferencedCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        LOG.debugf("Found collection with unloaded owner: %s", MessageHelper.collectionInfoString(entry.getLoadedPersister(), entry.getLoadedKey(), session.getFactory()));
        entry.setCurrentPersister(entry.getLoadedPersister());
        entry.setCurrentKey(entry.getLoadedKey());
        Collections.prepareCollectionForUpdate(coll, entry, session.getEntityMode(), session.getFactory());
    }

    public static void processReachableCollection(PersistentCollection collection, CollectionType type, Object entity, SessionImplementor session) throws HibernateException {
        collection.setOwner(entity);
        CollectionEntry ce = session.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("Found two representations of same collection: " + type.getRole());
        }
        if (ce.isReached()) {
            throw new HibernateException("Found shared references to a collection: " + type.getRole());
        }
        ce.setReached(true);
        SessionFactoryImplementor factory = session.getFactory();
        CollectionPersister persister = factory.getCollectionPersister(type.getRole());
        ce.setCurrentPersister(persister);
        ce.setCurrentKey(type.getKeyOfOwner(entity, session));
        if (LOG.isDebugEnabled()) {
            if (collection.wasInitialized()) {
                LOG.debugf("Collection found: %s, was: %s (initialized)", MessageHelper.collectionInfoString(persister, ce.getCurrentKey(), factory), MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), factory));
            } else {
                LOG.debugf("Collection found: %s, was: %s (uninitialized)", MessageHelper.collectionInfoString(persister, ce.getCurrentKey(), factory), MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), factory));
            }
        }
        Collections.prepareCollectionForUpdate(collection, ce, session.getEntityMode(), factory);
    }

    private static void prepareCollectionForUpdate(PersistentCollection collection, CollectionEntry entry, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (entry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        entry.setProcessed(true);
        CollectionPersister loadedPersister = entry.getLoadedPersister();
        CollectionPersister currentPersister = entry.getCurrentPersister();
        if (loadedPersister != null || currentPersister != null) {
            boolean ownerChanged;
            boolean bl = ownerChanged = loadedPersister != currentPersister || !currentPersister.getKeyType().isEqual(entry.getLoadedKey(), entry.getCurrentKey(), entityMode, factory);
            if (ownerChanged) {
                boolean orphanDeleteAndRoleChanged;
                boolean bl2 = orphanDeleteAndRoleChanged = loadedPersister != null && currentPersister != null && loadedPersister.hasOrphanDelete();
                if (orphanDeleteAndRoleChanged) {
                    throw new HibernateException("Don't change the reference to a collection with cascade=\"all-delete-orphan\": " + loadedPersister.getRole());
                }
                if (currentPersister != null) {
                    entry.setDorecreate(true);
                }
                if (loadedPersister != null) {
                    entry.setDoremove(true);
                    if (entry.isDorecreate()) {
                        LOG.trace("Forcing collection initialization");
                        collection.forceInitialization();
                    }
                }
            } else if (collection.isDirty()) {
                entry.setDoupdate(true);
            }
        }
    }
}

