/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.HibernateLogger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.NonstrictReadWriteCache;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.ReadOnlyCache;
import org.hibernate.cache.ReadWriteCache;
import org.hibernate.cache.TransactionalCache;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.impl.bridge.BaseTransactionalDataRegionAdapter;
import org.hibernate.cache.impl.bridge.CollectionAccessStrategyAdapter;
import org.hibernate.cache.impl.bridge.OptimisticCacheSourceAdapter;
import org.hibernate.cfg.Settings;
import org.jboss.logging.Logger;

public class CollectionRegionAdapter
extends BaseTransactionalDataRegionAdapter
implements CollectionRegion {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)CollectionRegionAdapter.class.getName());

    public CollectionRegionAdapter(Cache underlyingCache, Settings settings, CacheDataDescription metadata) {
        super(underlyingCache, settings, metadata);
        if (underlyingCache instanceof OptimisticCache) {
            ((OptimisticCache)underlyingCache).setSource(new OptimisticCacheSourceAdapter(metadata));
        }
    }

    @Override
    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        CacheConcurrencyStrategy ccs;
        if (AccessType.READ_ONLY.equals(accessType)) {
            if (this.metadata.isMutable()) {
                LOG.readOnlyCacheConfiguredForMutableCollection(this.getName());
            }
            ccs = new ReadOnlyCache();
        } else if (AccessType.READ_WRITE.equals(accessType)) {
            ccs = new ReadWriteCache();
        } else if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            ccs = new NonstrictReadWriteCache();
        } else if (AccessType.TRANSACTIONAL.equals(accessType)) {
            ccs = new TransactionalCache();
        } else {
            throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
        }
        ccs.setCache(this.underlyingCache);
        return new CollectionAccessStrategyAdapter(this, ccs, this.settings);
    }
}

