/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.AbstractInstrumenter;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.javassist.BytecodeProviderImpl;
import org.hibernate.bytecode.javassist.FieldHandled;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;

public class JavassistInstrumenter
extends AbstractInstrumenter {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();

    public JavassistInstrumenter(Logger logger2, Instrumenter.Options options) {
        super(logger2, options);
    }

    @Override
    protected ClassDescriptor getClassDescriptor(byte[] bytecode) throws IOException {
        return new CustomClassDescriptor(bytecode);
    }

    @Override
    protected ClassTransformer getClassTransformer(ClassDescriptor descriptor, Set classNames) {
        if (descriptor.isInstrumented()) {
            this.logger.debug("class [" + descriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new AbstractInstrumenter.CustomFieldFilter(this, descriptor, classNames));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytes;
        private final ClassFile classFile;

        public CustomClassDescriptor(byte[] bytes) throws IOException {
            this.bytes = bytes;
            this.classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytes)));
        }

        @Override
        public String getName() {
            return this.classFile.getName();
        }

        @Override
        public boolean isInstrumented() {
            String[] intfs = this.classFile.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                if (!FieldHandled.class.getName().equals(intfs[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

