/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.access.AccessType;

public enum CacheConcurrencyStrategy {
    NONE(null),
    READ_ONLY(AccessType.READ_ONLY),
    NONSTRICT_READ_WRITE(AccessType.NONSTRICT_READ_WRITE),
    READ_WRITE(AccessType.READ_WRITE),
    TRANSACTIONAL(AccessType.TRANSACTIONAL);

    private final AccessType accessType;

    private CacheConcurrencyStrategy(AccessType accessType) {
        this.accessType = accessType;
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        String name;
        String string = name = accessType == null ? null : accessType.getName();
        if (AccessType.READ_ONLY.getName().equals(name)) {
            return READ_ONLY;
        }
        if (AccessType.READ_WRITE.getName().equals(name)) {
            return READ_WRITE;
        }
        if (AccessType.NONSTRICT_READ_WRITE.getName().equals(name)) {
            return NONSTRICT_READ_WRITE;
        }
        if (AccessType.TRANSACTIONAL.getName().equals(name)) {
            return TRANSACTIONAL;
        }
        return NONE;
    }

    public static CacheConcurrencyStrategy parse(String name) {
        if (CacheConcurrencyStrategy.READ_ONLY.accessType.getName().equalsIgnoreCase(name)) {
            return READ_ONLY;
        }
        if (CacheConcurrencyStrategy.READ_WRITE.accessType.getName().equalsIgnoreCase(name)) {
            return READ_WRITE;
        }
        if (CacheConcurrencyStrategy.NONSTRICT_READ_WRITE.accessType.getName().equalsIgnoreCase(name)) {
            return NONSTRICT_READ_WRITE;
        }
        if (CacheConcurrencyStrategy.TRANSACTIONAL.accessType.getName().equalsIgnoreCase(name)) {
            return TRANSACTIONAL;
        }
        if ("none".equalsIgnoreCase(name)) {
            return NONE;
        }
        return null;
    }

    public AccessType toAccessType() {
        return this.accessType;
    }
}

