/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.EntityAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends EntityAction {
    private transient Object[] state;
    private final boolean isDelayed;
    private final EntityKey delayedEntityKey;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, SessionImplementor session, boolean isDelayed) throws HibernateException {
        super(session, isDelayed ? EntityIdentityInsertAction.generateDelayedPostInsertIdentifier() : null, instance, persister);
        this.state = state;
        this.isDelayed = isDelayed;
        this.delayedEntityKey = isDelayed ? this.generateDelayedEntityKey() : null;
    }

    @Override
    public void execute() throws HibernateException {
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preInsert();
        if (!veto) {
            this.generatedId = persister.insert(this.state, instance, session);
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(this.generatedId, instance, this.state, session);
            }
            persister.setIdentifier(instance, this.generatedId, session);
            this.getSession().getPersistenceContext().registerInsertedKey(this.getPersister(), this.generatedId);
        }
        this.postInsert();
        if (session.getFactory().getStatistics().isStatisticsEnabled() && !veto) {
            session.getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    @Override
    public boolean needsAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
        this.postCommitInsert();
    }

    private void postInsert() {
        PostInsertEventListener[] postListeners;
        if (this.isDelayed) {
            this.getSession().getPersistenceContext().replaceDelayedEntityIdentityInsertKeys(this.delayedEntityKey, this.generatedId);
        }
        if ((postListeners = this.getSession().getListeners().getPostInsertEventListeners()).length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preListeners = this.getSession().getListeners().getPreInsertEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreInsertEvent preEvent = new PreInsertEvent(this.getInstance(), null, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreInsert(preEvent) || veto;
            }
        }
        return veto;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }

    public EntityKey getDelayedEntityKey() {
        return this.delayedEntityKey;
    }

    private static synchronized DelayedPostInsertIdentifier generateDelayedPostInsertIdentifier() {
        return new DelayedPostInsertIdentifier();
    }

    private EntityKey generateDelayedEntityKey() {
        if (!this.isDelayed) {
            throw new AssertionFailure("cannot request delayed entity-key for non-delayed post-insert-id generation");
        }
        return new EntityKey(this.getDelayedId(), this.getPersister(), this.getSession().getEntityMode());
    }

    @Override
    public void afterDeserialize(SessionImplementor session) {
        super.afterDeserialize(session);
        if (session != null) {
            EntityEntry entityEntry = session.getPersistenceContext().getEntry(this.getInstance());
            this.state = entityEntry.getLoadedState();
        }
    }
}

