/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class EntityAction
implements Executable,
Serializable,
Comparable,
AfterTransactionCompletionProcess {
    private final String entityName;
    private final Serializable id;
    private transient Object instance;
    private transient SessionImplementor session;
    private transient EntityPersister persister;

    protected EntityAction(SessionImplementor session, Serializable id, Object instance, EntityPersister persister) {
        this.entityName = persister.getEntityName();
        this.id = id;
        this.instance = instance;
        this.session = session;
        this.persister = persister;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.needsAfterTransactionCompletion() ? this : null;
    }

    protected abstract boolean hasPostCommitEventListeners();

    public boolean needsAfterTransactionCompletion() {
        return this.persister.hasCache() || this.hasPostCommitEventListeners();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public final Serializable getId() {
        if (this.id instanceof DelayedPostInsertIdentifier) {
            Serializable eeId = this.session.getPersistenceContext().getEntry(this.instance).getId();
            return eeId instanceof DelayedPostInsertIdentifier ? null : eeId;
        }
        return this.id;
    }

    public final DelayedPostInsertIdentifier getDelayedId() {
        return DelayedPostInsertIdentifier.class.isInstance(this.id) ? (DelayedPostInsertIdentifier)DelayedPostInsertIdentifier.class.cast(this.id) : null;
    }

    public final Object getInstance() {
        return this.instance;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final EntityPersister getPersister() {
        return this.persister;
    }

    @Override
    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    @Override
    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    public int compareTo(Object other) {
        EntityAction action = (EntityAction)other;
        int roleComparison = this.entityName.compareTo(action.entityName);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getIdentifierType().compare(this.id, action.id, this.session.getEntityMode());
    }

    public void afterDeserialize(SessionImplementor session) {
        if (this.session != null || this.persister != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (session != null) {
            this.session = session;
            this.persister = session.getFactory().getEntityPersister(this.entityName);
            this.instance = session.getPersistenceContext().getEntity(new EntityKey(this.id, this.persister, session.getEntityMode()));
        }
    }
}

