/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.Property;
import java.util.Objects;

public abstract class Transition {
    protected Transition() {
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public abstract boolean isDirect();

    static final class ObjectFlagsTransition
    extends Transition {
        private final int objectFlags;

        ObjectFlagsTransition(int newFlags) {
            this.objectFlags = newFlags;
        }

        public int getObjectFlags() {
            return this.objectFlags;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.objectFlags == ((ObjectFlagsTransition)other).objectFlags;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.objectFlags;
            return result;
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        public String toString() {
            return String.format("objectFlags(%s)", this.getObjectFlags());
        }
    }

    public static final class ShareShapeTransition
    extends Transition {
        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static final class ReservePrimitiveArrayTransition
    extends Transition {
        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static final class DirectReplacePropertyTransition
    extends AbstractReplacePropertyTransition {
        public DirectReplacePropertyTransition(Property before, Property after) {
            super(before, after);
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public static final class IndirectReplacePropertyTransition
    extends AbstractReplacePropertyTransition {
        public IndirectReplacePropertyTransition(Property before, Property after) {
            super(before, after);
        }

        @Override
        public boolean isDirect() {
            return false;
        }
    }

    public static abstract class AbstractReplacePropertyTransition
    extends PropertyTransition {
        private final Property after;

        public AbstractReplacePropertyTransition(Property before, Property after) {
            super(before);
            this.after = after;
        }

        public Property getPropertyBefore() {
            return this.getProperty();
        }

        public Property getPropertyAfter() {
            return this.after;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.after.equals(((AbstractReplacePropertyTransition)obj).after);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.after.hashCode();
            return result;
        }

        public String toString() {
            return String.format("replace(%s,%s)", this.getPropertyBefore(), this.getPropertyAfter());
        }
    }

    public static final class ObjectTypeTransition
    extends Transition {
        private final Object objectType;

        public ObjectTypeTransition(Object objectType) {
            this.objectType = objectType;
        }

        public Object getObjectType() {
            return this.objectType;
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && Objects.equals(this.objectType, ((ObjectTypeTransition)other).objectType);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
            return result;
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        public String toString() {
            return String.format("objectType(%s)", this.getObjectType());
        }
    }

    public static final class RemovePropertyTransition
    extends PropertyTransition {
        private final boolean direct;

        public RemovePropertyTransition(Property property, boolean direct) {
            super(property);
            this.direct = direct;
        }

        @Override
        public boolean isDirect() {
            return this.direct;
        }

        public String toString() {
            return String.format("remove(%s)", this.getProperty());
        }
    }

    public static final class AddPropertyTransition
    extends PropertyTransition {
        public AddPropertyTransition(Property property) {
            super(property);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        public String toString() {
            return String.format("add(%s)", this.getProperty());
        }
    }

    public static abstract class PropertyTransition
    extends Transition {
        private final Property property;

        public PropertyTransition(Property property) {
            this.property = property;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            PropertyTransition other = (PropertyTransition)obj;
            return Objects.equals(this.property, other.property);
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

