/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotReferences;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguage
extends AbstractPolyglotImpl.AbstractLanguageImpl
implements PolyglotImpl.VMObject {
    final PolyglotEngineImpl engine;
    final LanguageCache cache;
    final LanguageInfo info;
    Language api;
    final int index;
    private final boolean host;
    final RuntimeException initError;
    private volatile OptionDescriptors options;
    private volatile OptionValuesImpl optionValues;
    private volatile boolean initialized;
    private volatile PolyglotLanguageInstance initLanguage;
    private final LinkedList<PolyglotLanguageInstance> instancePool;
    final ContextProfile profile;
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> multiLanguageReference;
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> singleOrMultiLanguageReference;
    private final TruffleLanguage.ContextReference<Object> multiContextReference;
    private final TruffleLanguage.ContextReference<Object> singleOrMultiContextReference;
    final Assumption singleInstance = Truffle.getRuntime().createAssumption("Single language instance per engine.");
    private boolean firstInstance = true;
    @CompilerDirectives.CompilationFinal
    volatile Class<?> contextClass;

    PolyglotLanguage(PolyglotEngineImpl engine, LanguageCache cache, int index, boolean host, RuntimeException initError) {
        super((AbstractPolyglotImpl)engine.impl);
        this.engine = engine;
        this.cache = cache;
        this.initError = initError;
        this.index = index;
        this.host = host;
        this.profile = new ContextProfile(this);
        this.instancePool = new LinkedList();
        this.info = EngineAccessor.NODES.createLanguage(this, cache.getId(), cache.getName(), cache.getVersion(), cache.getDefaultMimeType(), cache.getMimeTypes(), cache.isInternal(), cache.isInteractive());
        this.multiLanguageReference = PolyglotReferences.createAlwaysMultiLanguage(this);
        this.multiContextReference = PolyglotReferences.createAlwaysMultiContext(this);
        this.singleOrMultiContextReference = PolyglotReferences.createAssumeSingleContext(this, engine.singleContext, null, this.multiContextReference, false);
        this.singleOrMultiLanguageReference = PolyglotReferences.createAssumeSingleLanguage(this, null, this.singleInstance, this.multiLanguageReference);
    }

    TruffleLanguage.ContextPolicy getEffectiveContextPolicy(PolyglotLanguage inLanguage) {
        TruffleLanguage.ContextPolicy sourcePolicy = this.engine.boundEngine ? TruffleLanguage.ContextPolicy.EXCLUSIVE : (inLanguage != null ? inLanguage.cache.getPolicy() : TruffleLanguage.ContextPolicy.SHARED);
        return sourcePolicy;
    }

    PolyglotLanguageContext getCurrentLanguageContext() {
        return PolyglotContextImpl.requireContext().contexts[this.index];
    }

    void initializeContextClass(Object contextImpl) {
        CompilerAsserts.neverPartOfCompilation();
        Class newClass = contextImpl == null ? Void.class : contextImpl.getClass();
        Class<?> currentClass = this.contextClass;
        if (currentClass == null) {
            this.contextClass = newClass;
        } else if (currentClass != newClass) {
            throw new IllegalStateException(String.format("Unstable context class expected %s got %s.", newClass, currentClass));
        }
    }

    boolean dependsOn(PolyglotLanguage otherLanguage) {
        Set<String> dependentLanguages = this.cache.getDependentLanguages();
        if (dependentLanguages.contains(otherLanguage.getId())) {
            return true;
        }
        for (String dependentLanguage : dependentLanguages) {
            PolyglotLanguage dependentLanguageObj = this.engine.idToLanguage.get(dependentLanguage);
            if (dependentLanguageObj == null || !dependentLanguageObj.dependsOn(otherLanguage)) continue;
            return true;
        }
        return false;
    }

    boolean isHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionDescriptors getOptions() {
        this.engine.checkState();
        if (!this.initialized) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (!this.initialized) {
                    try {
                        this.initLanguage = this.ensureInitialized(new PolyglotLanguageInstance(this));
                    }
                    catch (IllegalAccessError e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        return OptionDescriptors.EMPTY;
                    }
                    this.initialized = true;
                }
            }
        }
        return this.options;
    }

    private PolyglotLanguageInstance createInstance() {
        assert (Thread.holdsLock(this.engine));
        if (this.firstInstance) {
            this.firstInstance = false;
        } else if (this.singleInstance.isValid()) {
            this.singleInstance.invalidate();
        }
        PolyglotLanguageInstance instance = null;
        if (this.initLanguage != null) {
            instance = this.initLanguage;
            this.initLanguage = null;
        }
        if (instance == null) {
            instance = this.ensureInitialized(new PolyglotLanguageInstance(this));
        }
        return instance;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance ensureInitialized(PolyglotLanguageInstance instance) {
        if (!this.initialized) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (!this.initialized) {
                    try {
                        this.options = EngineAccessor.LANGUAGE.describeOptions(instance.spi, this.cache.getId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", this.cache.getId(), this.cache.getClassName()), e);
                    }
                    this.initialized = true;
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLanguageInstance allocateInstance(OptionValuesImpl newOptions) {
        PolyglotLanguageInstance instance;
        PolyglotEngineImpl polyglotEngineImpl = this.engine;
        synchronized (polyglotEngineImpl) {
            switch (this.cache.getPolicy()) {
                case EXCLUSIVE: {
                    instance = this.createInstance();
                    break;
                }
                case REUSE: {
                    instance = this.fetchFromPool(newOptions, false);
                    break;
                }
                case SHARED: {
                    instance = this.fetchFromPool(newOptions, true);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown context cardinality.");
                }
            }
            instance.ensureMultiContextInitialized();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance fetchFromPool(OptionValuesImpl newOptions, boolean shared) {
        PolyglotEngineImpl polyglotEngineImpl = this.engine;
        synchronized (polyglotEngineImpl) {
            PolyglotLanguageInstance foundInstance = null;
            Iterator iterator = this.instancePool.iterator();
            while (iterator.hasNext()) {
                PolyglotLanguageInstance instance = (PolyglotLanguageInstance)iterator.next();
                if (!instance.areOptionsCompatible(newOptions)) continue;
                if (!shared) {
                    iterator.remove();
                }
                foundInstance = instance;
                break;
            }
            if (foundInstance == null) {
                foundInstance = this.createInstance();
                foundInstance.claim(newOptions);
                if (shared) {
                    this.instancePool.addFirst(foundInstance);
                }
            }
            return foundInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeInstance(PolyglotLanguageInstance instance) {
        PolyglotEngineImpl polyglotEngineImpl = this.engine;
        synchronized (polyglotEngineImpl) {
            switch (this.cache.getPolicy()) {
                case EXCLUSIVE: {
                    break;
                }
                case REUSE: {
                    this.profile.notifyLanguageFreed();
                    this.instancePool.addFirst(instance);
                    break;
                }
                case SHARED: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown context cardinality.");
                }
            }
        }
    }

    TruffleLanguage.ContextReference<Object> getContextReference() {
        if (this.singleInstance.isValid() && !this.engine.conservativeContextReferences) {
            return this.singleOrMultiContextReference;
        }
        return this.multiContextReference;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getLanguageReference() {
        if (this.singleInstance.isValid()) {
            return this.singleOrMultiLanguageReference;
        }
        return this.multiLanguageReference;
    }

    TruffleLanguage.ContextReference<Object> getConservativeContextReference() {
        return this.multiContextReference;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getConservativeLanguageReference() {
        return this.multiLanguageReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (this.optionValues == null) {
                    this.optionValues = new OptionValuesImpl(this.engine, this.getOptions(), false);
                }
            }
        }
        return this.optionValues;
    }

    OptionValuesImpl getOptionValuesIfExists() {
        return this.optionValues;
    }

    public String getDefaultMimeType() {
        return this.cache.getDefaultMimeType();
    }

    void clearOptionValues() {
        this.optionValues = null;
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getImplementationName() {
        return this.cache.getImplementationName();
    }

    public boolean isInteractive() {
        return this.cache.isInteractive();
    }

    public Set<String> getMimeTypes() {
        return this.cache.getMimeTypes();
    }

    public String getVersion() {
        String version = this.cache.getVersion();
        if (version.equals("inherit")) {
            return this.engine.creatorApi.getVersion();
        }
        return version;
    }

    public String getId() {
        return this.cache.getId();
    }

    public String toString() {
        return "PolyglotLanguage [id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.isHost() + "]";
    }

    boolean assertCorrectEngine() {
        PolyglotContextImpl context = PolyglotContextImpl.requireContext();
        PolyglotLanguageContext languageContext = context.getContext(this);
        if (languageContext.isInitialized() && languageContext.language.engine != this.engine) {
            throw new AssertionError((Object)String.format("Context reference was used from an Engine that is currently not entered. ContextReference of engine %s was used but engine %s is currently entered. ContextReference must not be shared between multiple Engine instances.", languageContext.language.engine.creatorApi, this.engine.creatorApi));
        }
        return true;
    }

    static final class ContextProfile {
        private static final Object UNSET_CONTEXT = new Object();
        private final Assumption singleContext;
        @CompilerDirectives.CompilationFinal
        private volatile Object cachedSingleContext = UNSET_CONTEXT;
        @CompilerDirectives.CompilationFinal
        private volatile Object cachedSingleLanguageContext = UNSET_CONTEXT;

        ContextProfile(PolyglotLanguage language) {
            this.singleContext = language.engine.boundEngine ? Truffle.getRuntime().createAssumption("Language single context.") : NeverValidAssumption.INSTANCE;
        }

        public Assumption getSingleContext() {
            return this.singleContext;
        }

        PolyglotLanguageContext profile(Object context) {
            if (this.singleContext.isValid()) {
                Object cachedSingle = this.cachedSingleLanguageContext;
                if (this.singleContext.isValid()) {
                    assert (cachedSingle == context) : ContextProfile.assertionError(cachedSingle, context);
                    return (PolyglotLanguageContext)cachedSingle;
                }
            }
            return (PolyglotLanguageContext)context;
        }

        static String assertionError(Object cachedContext, Object currentContext) {
            return cachedContext + " != " + currentContext;
        }

        void notifyContextCreate(PolyglotLanguageContext context, TruffleLanguage.Env env) {
            if (this.singleContext.isValid()) {
                Object cachedSingle = this.cachedSingleContext;
                assert (cachedSingle != EngineAccessor.LANGUAGE.getContext(env) || cachedSingle == null) : "Non-null context objects should be distinct";
                if (cachedSingle == UNSET_CONTEXT) {
                    if (this.singleContext.isValid()) {
                        this.cachedSingleContext = EngineAccessor.LANGUAGE.getContext(env);
                        this.cachedSingleLanguageContext = context;
                    }
                } else {
                    this.singleContext.invalidate();
                    this.cachedSingleContext = UNSET_CONTEXT;
                    this.cachedSingleLanguageContext = UNSET_CONTEXT;
                }
            }
        }

        void notifyLanguageFreed() {
            if (this.singleContext.isValid()) {
                this.cachedSingleContext = UNSET_CONTEXT;
                this.cachedSingleLanguageContext = UNSET_CONTEXT;
            }
        }
    }
}

