/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.graalvm.buildtools.maven.config.AbstractMergeAgentFilesMojo;
import org.graalvm.buildtools.maven.config.agent.AgentConfiguration;

@Mojo(name="merge-agent-files", defaultPhase=LifecyclePhase.TEST)
public class MergeAgentFilesMojo
extends AbstractMergeAgentFilesMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected String target;
    @Parameter(property="native.agent.merge.context", required=true)
    protected String context;
    @Parameter(alias="agent")
    private AgentConfiguration agentConfiguration;
    private static int numberOfExecutions = 0;

    public void execute() throws MojoExecutionException {
        if (++numberOfExecutions > 1) {
            return;
        }
        if (this.agentConfiguration == null) {
            this.agentConfiguration = new AgentConfiguration();
        }
        if (this.agentConfiguration.getDefaultMode().equalsIgnoreCase("direct")) {
            this.logger.info("Skipping files merge mojo since we are in direct mode");
            return;
        }
        List<String> disabledPhases = this.agentConfiguration.getMetadataCopyConfiguration().getDisabledStages();
        if (disabledPhases.size() == 2) {
            this.logger.info("Both phases are skipped.");
            return;
        }
        HashSet<String> dirs = new HashSet<String>(2);
        dirs.addAll(Arrays.asList("main", "test"));
        dirs.removeAll(disabledPhases);
        for (String dir : dirs) {
            String agentOutputDirectory = (this.target + "/native/agent-output/" + dir).replace('/', File.separatorChar);
            this.mergeForGivenDir(agentOutputDirectory);
        }
    }

    private void mergeForGivenDir(String agentOutputDirectory) throws MojoExecutionException {
        File baseDir = new File(agentOutputDirectory);
        if (baseDir.exists()) {
            List<File> sessionDirectories = MergeAgentFilesMojo.sessionDirectoriesFrom(baseDir.listFiles()).collect(Collectors.toList());
            if (sessionDirectories.size() == 0) {
                sessionDirectories = Collections.singletonList(baseDir);
            }
            this.invokeMerge(sessionDirectories, baseDir);
        } else {
            this.getLog().debug((CharSequence)("Agent output directory " + baseDir + " doesn't exist. Skipping merge."));
        }
    }

    private static Stream<File> sessionDirectoriesFrom(File[] files) {
        return Arrays.stream(files).filter(File::isDirectory).filter(f -> f.getName().startsWith("session-"));
    }

    private void invokeMerge(List<File> inputDirectories, File outputDirectory) throws MojoExecutionException {
        File mergerExecutable = this.getMergerExecutable();
        try {
            if (inputDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)"Skipping merging of agent files since there are no input directories.");
                return;
            }
            this.getLog().info((CharSequence)("Merging agent " + inputDirectories.size() + " files into " + outputDirectory));
            List optionsInputDirs = inputDirectories.stream().map(File::getAbsolutePath).collect(Collectors.toList());
            List<String> optionsOutputDirs = Collections.singletonList(outputDirectory.getAbsolutePath());
            List args = this.agentConfiguration.getAgentMode().getNativeImageConfigureOptions(optionsInputDirs, optionsOutputDirs);
            ProcessBuilder processBuilder = new ProcessBuilder(mergerExecutable.toString());
            processBuilder.command().addAll(args);
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
            if (inputDirectories.size() != 1 || !inputDirectories.get(0).equals(outputDirectory)) {
                for (File inputDirectory : inputDirectories) {
                    FileUtils.deleteDirectory((File)inputDirectory);
                }
            }
            this.getLog().debug((CharSequence)("Agent output: " + Arrays.toString(outputDirectory.listFiles())));
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Merging agent files with " + mergerExecutable + " failed", e);
        }
    }
}

