/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.GDIObject;
import org.freehep.graphicsio.emf.gdi.StockObjects;

public class SelectObject
extends EMFTag {
    private int index;

    public SelectObject() {
        super(37, 1);
    }

    public SelectObject(int index) {
        this();
        this.index = index;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new SelectObject(emf.readDWORD());
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.index);
    }

    public String toString() {
        return super.toString() + "\n  index: 0x" + Integer.toHexString(this.index);
    }

    public void render(EMFRenderer renderer) {
        GDIObject gdiObject = this.index < 0 ? StockObjects.getStockObject(this.index) : renderer.getGDIObject(this.index);
        if (gdiObject != null) {
            gdiObject.render(renderer);
        } else {
            EMFTag.logger.warning("gdi object with index " + this.index + " not found");
        }
    }
}

