/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.process;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TimingStats
implements ToXContentObject {
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField TOTAL_BUCKET_PROCESSING_TIME_MS = new ParseField("total_bucket_processing_time_ms", new String[0]);
    public static final ParseField MIN_BUCKET_PROCESSING_TIME_MS = new ParseField("minimum_bucket_processing_time_ms", new String[0]);
    public static final ParseField MAX_BUCKET_PROCESSING_TIME_MS = new ParseField("maximum_bucket_processing_time_ms", new String[0]);
    public static final ParseField AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("average_bucket_processing_time_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("exponential_average_bucket_processing_time_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_PER_HOUR_MS = new ParseField("exponential_average_bucket_processing_time_per_hour_ms", new String[0]);
    public static final ConstructingObjectParser<TimingStats, Void> PARSER = new ConstructingObjectParser("timing_stats", true, args -> {
        String jobId = (String)args[0];
        Long bucketCount = (Long)args[1];
        Double totalBucketProcessingTimeMs = (Double)args[2];
        Double minBucketProcessingTimeMs = (Double)args[3];
        Double maxBucketProcessingTimeMs = (Double)args[4];
        Double avgBucketProcessingTimeMs = (Double)args[5];
        Double exponentialAvgBucketProcessingTimeMs = (Double)args[6];
        Double exponentialAvgBucketProcessingTimePerHourMs = (Double)args[7];
        return new TimingStats(jobId, TimingStats.getOrDefault(bucketCount, 0L), TimingStats.getOrDefault(totalBucketProcessingTimeMs, 0.0), minBucketProcessingTimeMs, maxBucketProcessingTimeMs, avgBucketProcessingTimeMs, exponentialAvgBucketProcessingTimeMs, exponentialAvgBucketProcessingTimePerHourMs);
    });
    private final String jobId;
    private long bucketCount;
    private double totalBucketProcessingTimeMs;
    private Double minBucketProcessingTimeMs;
    private Double maxBucketProcessingTimeMs;
    private Double avgBucketProcessingTimeMs;
    private Double exponentialAvgBucketProcessingTimeMs;
    private Double exponentialAvgBucketProcessingTimePerHourMs;

    public TimingStats(String jobId, long bucketCount, double totalBucketProcessingTimeMs, @Nullable Double minBucketProcessingTimeMs, @Nullable Double maxBucketProcessingTimeMs, @Nullable Double avgBucketProcessingTimeMs, @Nullable Double exponentialAvgBucketProcessingTimeMs, @Nullable Double exponentialAvgBucketProcessingTimePerHourMs) {
        this.jobId = jobId;
        this.bucketCount = bucketCount;
        this.totalBucketProcessingTimeMs = totalBucketProcessingTimeMs;
        this.minBucketProcessingTimeMs = minBucketProcessingTimeMs;
        this.maxBucketProcessingTimeMs = maxBucketProcessingTimeMs;
        this.avgBucketProcessingTimeMs = avgBucketProcessingTimeMs;
        this.exponentialAvgBucketProcessingTimeMs = exponentialAvgBucketProcessingTimeMs;
        this.exponentialAvgBucketProcessingTimePerHourMs = exponentialAvgBucketProcessingTimePerHourMs;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public double getTotalBucketProcessingTimeMs() {
        return this.totalBucketProcessingTimeMs;
    }

    public Double getMinBucketProcessingTimeMs() {
        return this.minBucketProcessingTimeMs;
    }

    public Double getMaxBucketProcessingTimeMs() {
        return this.maxBucketProcessingTimeMs;
    }

    public Double getAvgBucketProcessingTimeMs() {
        return this.avgBucketProcessingTimeMs;
    }

    public Double getExponentialAvgBucketProcessingTimeMs() {
        return this.exponentialAvgBucketProcessingTimeMs;
    }

    public Double getExponentialAvgBucketProcessingTimePerHourMs() {
        return this.exponentialAvgBucketProcessingTimePerHourMs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        builder.field(TOTAL_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.totalBucketProcessingTimeMs);
        if (this.minBucketProcessingTimeMs != null) {
            builder.field(MIN_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.minBucketProcessingTimeMs);
        }
        if (this.maxBucketProcessingTimeMs != null) {
            builder.field(MAX_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.maxBucketProcessingTimeMs);
        }
        if (this.avgBucketProcessingTimeMs != null) {
            builder.field(AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.avgBucketProcessingTimeMs);
        }
        if (this.exponentialAvgBucketProcessingTimeMs != null) {
            builder.field(EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.exponentialAvgBucketProcessingTimeMs);
        }
        if (this.exponentialAvgBucketProcessingTimePerHourMs != null) {
            builder.field(EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_PER_HOUR_MS.getPreferredName(), this.exponentialAvgBucketProcessingTimePerHourMs);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.jobId, that.jobId) && this.bucketCount == that.bucketCount && this.totalBucketProcessingTimeMs == that.totalBucketProcessingTimeMs && Objects.equals(this.minBucketProcessingTimeMs, that.minBucketProcessingTimeMs) && Objects.equals(this.maxBucketProcessingTimeMs, that.maxBucketProcessingTimeMs) && Objects.equals(this.avgBucketProcessingTimeMs, that.avgBucketProcessingTimeMs) && Objects.equals(this.exponentialAvgBucketProcessingTimeMs, that.exponentialAvgBucketProcessingTimeMs) && Objects.equals(this.exponentialAvgBucketProcessingTimePerHourMs, that.exponentialAvgBucketProcessingTimePerHourMs);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.bucketCount, this.totalBucketProcessingTimeMs, this.minBucketProcessingTimeMs, this.maxBucketProcessingTimeMs, this.avgBucketProcessingTimeMs, this.exponentialAvgBucketProcessingTimeMs, this.exponentialAvgBucketProcessingTimePerHourMs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), BUCKET_COUNT);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TOTAL_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MIN_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MAX_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), AVG_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_PER_HOUR_MS);
    }
}

