/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class MeanSquaredErrorMetric
implements EvaluationMetric {
    public static final String NAME = "mean_squared_error";
    private static final ObjectParser<MeanSquaredErrorMetric, Void> PARSER = new ObjectParser("mean_squared_error", true, MeanSquaredErrorMetric::new);

    public static MeanSquaredErrorMetric fromXContent(XContentParser parser) {
        return (MeanSquaredErrorMetric)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Result
    implements EvaluationMetric.Result {
        public static final ParseField ERROR = new ParseField("error", new String[0]);
        private final double error;
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("mean_squared_error_result", true, args -> new Result((Double)args[0]));

        public static Result fromXContent(XContentParser parser) {
            return (Result)PARSER.apply(parser, null);
        }

        public Result(double error) {
            this.error = error;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ERROR.getPreferredName(), this.error);
            builder.endObject();
            return builder;
        }

        public double getError() {
            return this.error;
        }

        @Override
        public String getMetricName() {
            return MeanSquaredErrorMetric.NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(that.error, this.error);
        }

        public int hashCode() {
            return Objects.hash(this.error);
        }

        static {
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), ERROR);
        }
    }
}

