/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.stats.classification;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Hyperparameters
implements ToXContentObject {
    public static final ParseField CLASS_ASSIGNMENT_OBJECTIVE = new ParseField("class_assignment_objective", new String[0]);
    public static final ParseField ALPHA = new ParseField("alpha", new String[0]);
    public static final ParseField DOWNSAMPLE_FACTOR = new ParseField("downsample_factor", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField ETA_GROWTH_RATE_PER_TREE = new ParseField("eta_growth_rate_per_tree", new String[0]);
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField MAX_ATTEMPTS_TO_ADD_TREE = new ParseField("max_attempts_to_add_tree", new String[0]);
    public static final ParseField MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER = new ParseField("max_optimization_rounds_per_hyperparameter", new String[0]);
    public static final ParseField MAX_TREES = new ParseField("max_trees", new String[0]);
    public static final ParseField NUM_FOLDS = new ParseField("num_folds", new String[0]);
    public static final ParseField NUM_SPLITS_PER_FEATURE = new ParseField("num_splits_per_feature", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_LIMIT = new ParseField("soft_tree_depth_limit", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_TOLERANCE = new ParseField("soft_tree_depth_tolerance", new String[0]);
    public static ConstructingObjectParser<Hyperparameters, Void> PARSER = new ConstructingObjectParser("classification_hyperparameters", true, a -> new Hyperparameters((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Double)a[4], (Double)a[5], (Double)a[6], (Double)a[7], (Integer)a[8], (Integer)a[9], (Integer)a[10], (Integer)a[11], (Integer)a[12], (Double)a[13], (Double)a[14]));
    private final String classAssignmentObjective;
    private final Double alpha;
    private final Double downsampleFactor;
    private final Double eta;
    private final Double etaGrowthRatePerTree;
    private final Double featureBagFraction;
    private final Double gamma;
    private final Double lambda;
    private final Integer maxAttemptsToAddTree;
    private final Integer maxOptimizationRoundsPerHyperparameter;
    private final Integer maxTrees;
    private final Integer numFolds;
    private final Integer numSplitsPerFeature;
    private final Double softTreeDepthLimit;
    private final Double softTreeDepthTolerance;

    public Hyperparameters(String classAssignmentObjective, Double alpha, Double downsampleFactor, Double eta, Double etaGrowthRatePerTree, Double featureBagFraction, Double gamma, Double lambda, Integer maxAttemptsToAddTree, Integer maxOptimizationRoundsPerHyperparameter, Integer maxTrees, Integer numFolds, Integer numSplitsPerFeature, Double softTreeDepthLimit, Double softTreeDepthTolerance) {
        this.classAssignmentObjective = classAssignmentObjective;
        this.alpha = alpha;
        this.downsampleFactor = downsampleFactor;
        this.eta = eta;
        this.etaGrowthRatePerTree = etaGrowthRatePerTree;
        this.featureBagFraction = featureBagFraction;
        this.gamma = gamma;
        this.lambda = lambda;
        this.maxAttemptsToAddTree = maxAttemptsToAddTree;
        this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
        this.maxTrees = maxTrees;
        this.numFolds = numFolds;
        this.numSplitsPerFeature = numSplitsPerFeature;
        this.softTreeDepthLimit = softTreeDepthLimit;
        this.softTreeDepthTolerance = softTreeDepthTolerance;
    }

    public String getClassAssignmentObjective() {
        return this.classAssignmentObjective;
    }

    public Double getAlpha() {
        return this.alpha;
    }

    public Double getDownsampleFactor() {
        return this.downsampleFactor;
    }

    public Double getEta() {
        return this.eta;
    }

    public Double getEtaGrowthRatePerTree() {
        return this.etaGrowthRatePerTree;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Integer getMaxAttemptsToAddTree() {
        return this.maxAttemptsToAddTree;
    }

    public Integer getMaxOptimizationRoundsPerHyperparameter() {
        return this.maxOptimizationRoundsPerHyperparameter;
    }

    public Integer getMaxTrees() {
        return this.maxTrees;
    }

    public Integer getNumFolds() {
        return this.numFolds;
    }

    public Integer getNumSplitsPerFeature() {
        return this.numSplitsPerFeature;
    }

    public Double getSoftTreeDepthLimit() {
        return this.softTreeDepthLimit;
    }

    public Double getSoftTreeDepthTolerance() {
        return this.softTreeDepthTolerance;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.classAssignmentObjective != null) {
            builder.field(CLASS_ASSIGNMENT_OBJECTIVE.getPreferredName(), this.classAssignmentObjective);
        }
        if (this.alpha != null) {
            builder.field(ALPHA.getPreferredName(), this.alpha);
        }
        if (this.downsampleFactor != null) {
            builder.field(DOWNSAMPLE_FACTOR.getPreferredName(), this.downsampleFactor);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.etaGrowthRatePerTree != null) {
            builder.field(ETA_GROWTH_RATE_PER_TREE.getPreferredName(), this.etaGrowthRatePerTree);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.maxAttemptsToAddTree != null) {
            builder.field(MAX_ATTEMPTS_TO_ADD_TREE.getPreferredName(), this.maxAttemptsToAddTree);
        }
        if (this.maxOptimizationRoundsPerHyperparameter != null) {
            builder.field(MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName(), this.maxOptimizationRoundsPerHyperparameter);
        }
        if (this.maxTrees != null) {
            builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.numFolds != null) {
            builder.field(NUM_FOLDS.getPreferredName(), this.numFolds);
        }
        if (this.numSplitsPerFeature != null) {
            builder.field(NUM_SPLITS_PER_FEATURE.getPreferredName(), this.numSplitsPerFeature);
        }
        if (this.softTreeDepthLimit != null) {
            builder.field(SOFT_TREE_DEPTH_LIMIT.getPreferredName(), this.softTreeDepthLimit);
        }
        if (this.softTreeDepthTolerance != null) {
            builder.field(SOFT_TREE_DEPTH_TOLERANCE.getPreferredName(), this.softTreeDepthTolerance);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hyperparameters that = (Hyperparameters)o;
        return Objects.equals(this.classAssignmentObjective, that.classAssignmentObjective) && Objects.equals(this.alpha, that.alpha) && Objects.equals(this.downsampleFactor, that.downsampleFactor) && Objects.equals(this.eta, that.eta) && Objects.equals(this.etaGrowthRatePerTree, that.etaGrowthRatePerTree) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.lambda, that.lambda) && Objects.equals(this.maxAttemptsToAddTree, that.maxAttemptsToAddTree) && Objects.equals(this.maxOptimizationRoundsPerHyperparameter, that.maxOptimizationRoundsPerHyperparameter) && Objects.equals(this.maxTrees, that.maxTrees) && Objects.equals(this.numFolds, that.numFolds) && Objects.equals(this.numSplitsPerFeature, that.numSplitsPerFeature) && Objects.equals(this.softTreeDepthLimit, that.softTreeDepthLimit) && Objects.equals(this.softTreeDepthTolerance, that.softTreeDepthTolerance);
    }

    public int hashCode() {
        return Objects.hash(this.classAssignmentObjective, this.alpha, this.downsampleFactor, this.eta, this.etaGrowthRatePerTree, this.featureBagFraction, this.gamma, this.lambda, this.maxAttemptsToAddTree, this.maxOptimizationRoundsPerHyperparameter, this.maxTrees, this.numFolds, this.numSplitsPerFeature, this.softTreeDepthLimit, this.softTreeDepthTolerance);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CLASS_ASSIGNMENT_OBJECTIVE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ALPHA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), DOWNSAMPLE_FACTOR);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA_GROWTH_RATE_PER_TREE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_ATTEMPTS_TO_ADD_TREE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_TREES);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_FOLDS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_SPLITS_PER_FEATURE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_LIMIT);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), SOFT_TREE_DEPTH_TOLERANCE);
    }
}

