/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.util.Comparator;
import java.util.Optional;
import org.eclipse.rdf4j.common.lang.ObjectUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class ValueComparator
implements Comparator<Value> {
    private boolean strict = true;

    @Override
    public int compare(Value o1, Value o2) {
        if (ObjectUtil.nullEquals((Object)o1, (Object)o2)) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1 instanceof BNode;
        boolean b2 = o2 instanceof BNode;
        if (b1 && b2) {
            return this.compareBNodes((BNode)o1, (BNode)o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean u1 = o1 instanceof IRI;
        boolean u2 = o2 instanceof IRI;
        if (u1 && u2) {
            return this.compareURIs((IRI)o1, (IRI)o2);
        }
        if (u1) {
            return -1;
        }
        if (u2) {
            return 1;
        }
        boolean l1 = o1 instanceof Literal;
        boolean l2 = o2 instanceof Literal;
        if (l1 && l2) {
            return this.compareLiterals((Literal)o1, (Literal)o2);
        }
        if (l1) {
            return -1;
        }
        if (l2) {
            return 1;
        }
        return this.compareTriples((Triple)o1, (Triple)o2);
    }

    public void setStrict(boolean flag) {
        this.strict = flag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    private int compareBNodes(BNode leftBNode, BNode rightBNode) {
        return leftBNode.getID().compareTo(rightBNode.getID());
    }

    private int compareURIs(IRI leftURI, IRI rightURI) {
        return leftURI.toString().compareTo(rightURI.toString());
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        if (!QueryEvaluationUtil.isPlainLiteral((Value)leftLit) && !QueryEvaluationUtil.isPlainLiteral((Value)rightLit)) {
            try {
                boolean isSmaller = QueryEvaluationUtil.compareLiterals(leftLit, rightLit, Compare.CompareOp.LT, this.strict);
                if (isSmaller) {
                    return -1;
                }
                boolean isEquivalent = QueryEvaluationUtil.compareLiterals(leftLit, rightLit, Compare.CompareOp.EQ, this.strict);
                if (isEquivalent) {
                    return 0;
                }
                return 1;
            }
            catch (ValueExprEvaluationException isSmaller) {
                // empty catch block
            }
        }
        int result = 0;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            result = rightDatatype != null ? this.compareDatatypes(leftDatatype, rightDatatype) : 1;
        } else if (rightDatatype != null) {
            result = -1;
        }
        if (result == 0) {
            Optional leftLanguage = leftLit.getLanguage();
            Optional rightLanguage = rightLit.getLanguage();
            if (leftLanguage.isPresent()) {
                result = rightLanguage.isPresent() ? ((String)leftLanguage.get()).compareTo((String)rightLanguage.get()) : 1;
            } else if (rightLanguage.isPresent()) {
                result = -1;
            }
        }
        if (result == 0) {
            result = leftLit.getLabel().compareTo(rightLit.getLabel());
        }
        return result;
    }

    private int compareDatatypes(IRI leftDatatype, IRI rightDatatype) {
        if (XMLDatatypeUtil.isNumericDatatype((IRI)leftDatatype)) {
            if (XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype)) {
            return 1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype((IRI)leftDatatype)) {
            if (XMLDatatypeUtil.isCalendarDatatype((IRI)rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype((IRI)rightDatatype)) {
            return 1;
        }
        return this.compareURIs(leftDatatype, rightDatatype);
    }

    private int compareTriples(Triple leftTriple, Triple rightTriple) {
        int c = this.compare((Value)leftTriple.getSubject(), (Value)rightTriple.getSubject());
        if (c == 0 && (c = this.compare((Value)leftTriple.getPredicate(), (Value)rightTriple.getPredicate())) == 0) {
            c = this.compare(leftTriple.getObject(), rightTriple.getObject());
        }
        return c;
    }
}

