/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.packager.rpm.build.Defaults;
import org.eclipse.packager.rpm.build.FileInformation;
import org.eclipse.packager.rpm.build.FileInformationCustomizer;
import org.eclipse.packager.rpm.build.FileInformationProvider;
import org.eclipse.packager.rpm.build.PayloadEntryType;
import org.eclipse.packager.rpm.build.ProviderRule;
import org.eclipse.packager.rpm.build.SimpleFileInformationCustomizer;

public interface BuilderContext {
    public static final String DEFAULT_USER = "root";
    public static final String DEFAULT_GROUP = "root";
    public static final Directory DIRECTORY = new Directory();
    public static final SymbolicLink SYMBOLIC_LINK = new SymbolicLink();

    public static FileInformationCustomizer<Path> pathCustomizer() {
        return new FileInformationCustomizer<Path>(){

            @Override
            public void perform(Path path, FileInformation information) throws IOException {
                information.setTimestamp(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
            }
        };
    }

    public static SimpleFileInformationCustomizer nowTimestampCustomizer() {
        return Defaults.NOW_TIMESTAMP_CUSTOMIZER;
    }

    public static SimpleFileInformationCustomizer modeCustomizer(final short mode) {
        return new SimpleFileInformationCustomizer(){

            @Override
            public void perform(FileInformation information) {
                information.setMode(mode);
            }
        };
    }

    public static FileInformationProvider<Path> pathProvider() {
        return Defaults.PATH_PROVIDER;
    }

    public static <T> FileInformationProvider<T> simpleProvider(int mode) {
        return new FileInformationProvider<T>(){

            @Override
            public FileInformation provide(String targetName, T object, PayloadEntryType type) throws IOException {
                return new FileInformation();
            }
        }.customize(BuilderContext.nowTimestampCustomizer()).customize(BuilderContext.modeCustomizer((short)mode));
    }

    public static <T> FileInformationProvider<T> simpleFileProvider() {
        return Defaults.SIMPLE_FILE_PROVIDER;
    }

    public static <T> FileInformationProvider<T> simpleDirectoryProvider() {
        return Defaults.SIMPLE_DIRECTORY_PROVIDER;
    }

    public static <T> FileInformationProvider<T> multiProvider(FileInformationProvider<Object> defaultProvider, ProviderRule<?> ... rules) {
        Objects.requireNonNull(rules);
        return BuilderContext.multiProvider(defaultProvider, Arrays.asList(rules));
    }

    public static <T> FileInformationProvider<T> multiProvider(final FileInformationProvider<Object> defaultProvider, final List<ProviderRule<?>> rules) {
        Objects.requireNonNull(defaultProvider);
        Objects.requireNonNull(rules);
        return new FileInformationProvider<T>(){

            @Override
            public FileInformation provide(String targetName, Object object, PayloadEntryType type) throws IOException {
                for (ProviderRule rule : rules) {
                    FileInformation result = rule.run(targetName, object, type);
                    if (result == null) continue;
                    return result;
                }
                return defaultProvider.provide(targetName, object, type);
            }
        };
    }

    public static <T> FileInformationProvider<T> defaultProvider() {
        return Defaults.DEFAULT_MULTI_PROVIDER;
    }

    public void setDefaultInformationProvider(FileInformationProvider<Object> var1);

    public FileInformationProvider<Object> getDefaultInformationProvider();

    default public void addFile(String targetName, Path source) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider());
    }

    public void addFile(String var1, Path var2, FileInformationProvider<? super Path> var3) throws IOException;

    default public void addFile(String targetName, Path source, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider().customize(customizer));
    }

    default public void addFile(String targetName, InputStream source) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider());
    }

    public void addFile(String var1, InputStream var2, FileInformationProvider<Object> var3) throws IOException;

    default public void addFile(String targetName, InputStream source, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider().customize(customizer));
    }

    default public void addFile(String targetName, ByteBuffer source) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider());
    }

    public void addFile(String var1, ByteBuffer var2, FileInformationProvider<Object> var3) throws IOException;

    default public void addFile(String targetName, ByteBuffer source, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider().customize(customizer));
    }

    default public void addFile(String targetName, byte[] source) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider());
    }

    default public void addFile(String targetName, byte[] source, FileInformationProvider<Object> provider) throws IOException {
        this.addFile(targetName, ByteBuffer.wrap(source), provider);
    }

    default public void addFile(String targetName, byte[] source, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addFile(targetName, source, this.getDefaultInformationProvider().customize(customizer));
    }

    default public void addDirectory(String targetName) throws IOException {
        this.addDirectory(targetName, this.getDefaultInformationProvider());
    }

    public void addDirectory(String var1, FileInformationProvider<? super Directory> var2) throws IOException;

    default public void addDirectory(String targetName, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addDirectory(targetName, this.getDefaultInformationProvider().customize(customizer));
    }

    public void addSymbolicLink(String var1, String var2, FileInformationProvider<? super SymbolicLink> var3) throws IOException;

    default public void addSymbolicLink(String targetName, String linkTo) throws IOException {
        this.addSymbolicLink(targetName, linkTo, this.getDefaultInformationProvider());
    }

    default public void addSymbolicLink(String targetName, String linkTo, SimpleFileInformationCustomizer customizer) throws IOException {
        this.addSymbolicLink(targetName, linkTo, this.getDefaultInformationProvider().customize(customizer));
    }

    public static final class Directory {
        private Directory() {
        }
    }

    public static final class SymbolicLink {
        private SymbolicLink() {
        }
    }
}

