/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.deps;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;

public class Dependency
implements Comparable<Dependency> {
    private static final Comparator<Dependency> COMPARATOR = Comparator.comparing(Dependency::getName).thenComparing(Dependency::getVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(d -> RpmDependencyFlags.encode(d.getFlags()), Comparator.naturalOrder());
    private final String name;
    private final String version;
    private final EnumSet<RpmDependencyFlags> flags;

    public Dependency(String name, String version, RpmDependencyFlags ... flags) {
        this.name = name;
        this.version = version;
        this.flags = flags == null || flags.length == 0 ? EnumSet.noneOf(RpmDependencyFlags.class) : EnumSet.copyOf(Arrays.asList(flags));
    }

    public Dependency(String name, String version, Set<RpmDependencyFlags> flags) {
        this.name = name;
        this.version = version;
        this.flags = flags == null || flags.isEmpty() ? EnumSet.noneOf(RpmDependencyFlags.class) : EnumSet.copyOf(flags);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public EnumSet<RpmDependencyFlags> getFlags() {
        return this.flags;
    }

    public boolean isRpmLib() {
        return this.flags.contains((Object)RpmDependencyFlags.RPMLIB);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return String.format("[%s, %s, %s]", this.name, this.version, this.flags);
    }

    @Override
    public int compareTo(Dependency o) {
        return COMPARATOR.compare(this, o);
    }
}

