/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.client.SimpleEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;

public class SimpleServerEndpointMetadata
extends SimpleEndpointMetadata
implements ServerEndpointMetadata {
    private final ServerEndpointConfig config;

    public SimpleServerEndpointMetadata(Class<? extends Endpoint> endpointClass, ServerEndpointConfig config) {
        super(endpointClass);
        this.config = config;
        if (this.config != null) {
            this.getDecoders().addAll(config.getDecoders());
            this.getEncoders().addAll(config.getEncoders());
        }
    }

    @Override
    public ServerEndpointConfig getConfig() {
        return this.config;
    }

    @Override
    public String getPath() {
        return this.config.getPath();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleServerEndpointMetadata [");
        builder.append("config=").append(this.config.getClass().getName());
        builder.append(",path=").append(this.config.getPath());
        builder.append(",endpoint=").append(this.config.getEndpointClass());
        builder.append(",decoders=").append(this.config.getDecoders());
        builder.append(",encoders=").append(this.config.getEncoders());
        builder.append("]");
        return builder.toString();
    }
}

