/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ByteBufferUtils {
    private static final Method cleanerMethod;
    private static final Method cleanMethod;

    private ByteBufferUtils() {
    }

    public static ByteBuffer expand(ByteBuffer in, int newSize) {
        ByteBuffer out;
        if (in.capacity() >= newSize) {
            return in;
        }
        boolean direct = false;
        if (in.isDirect()) {
            out = ByteBuffer.allocateDirect(newSize);
            direct = true;
        } else {
            out = ByteBuffer.allocate(newSize);
        }
        in.flip();
        out.put(in);
        if (direct) {
            ByteBufferUtils.cleanDirectBuffer(in);
        }
        return out;
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        try {
            cleanMethod.invoke(cleanerMethod.invoke((Object)buf, new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    static {
        try {
            ByteBuffer tempBuffer = ByteBuffer.allocateDirect(0);
            cleanerMethod = tempBuffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleanerObject = cleanerMethod.invoke((Object)tempBuffer, new Object[0]);
            cleanMethod = cleanerObject.getClass().getMethod("clean", new Class[0]);
            cleanMethod.invoke(cleanerObject, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

