/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements AsyncEndPoint,
ConnectedEndPoint {
    public static final Logger __log = Log.getLogger("org.eclipse.jetty.io.nio");
    private final SelectorManager.SelectSet _selectSet;
    private final SelectorManager _manager;
    private final Runnable _handler = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.handle();
        }
    };
    private volatile Connection _connection;
    private boolean _dispatched = false;
    private boolean _redispatched = false;
    private volatile boolean _writable = true;
    private SelectionKey _key;
    private int _interestOps;
    private boolean _readBlocked;
    private boolean _writeBlocked;
    private boolean _open;
    private volatile long _idleTimestamp;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, int maxIdleTime) throws IOException {
        super(channel, maxIdleTime);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._dispatched = false;
        this._redispatched = false;
        this._open = true;
        this._key = key;
        this._connection = this._manager.newConnection(channel, this);
        this.scheduleIdle();
    }

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        super(channel);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._dispatched = false;
        this._redispatched = false;
        this._open = true;
        this._key = key;
        this._connection = this._manager.newConnection(channel, this);
        this.scheduleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey getSelectionKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return this._key;
        }
    }

    public SelectorManager getSelectManager() {
        return this._manager;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        Connection old = this._connection;
        this._connection = connection;
        this._manager.endPointUpgraded(this, old);
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                if (this._dispatched) {
                    this._key.interestOps(0);
                }
                return;
            }
            if (!this.isReadyForDispatch()) {
                this._key.interestOps(0);
                return;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            if (!this._dispatched) {
                this.dispatch();
                if (this._dispatched && !this._selectSet.getManager().isDeferringInterestedOps0()) {
                    this._key.interestOps(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._dispatched) {
                this._redispatched = true;
            } else {
                this._dispatched = true;
                boolean dispatched = this._manager.dispatch(this._handler);
                if (!dispatched) {
                    this._dispatched = false;
                    __log.warn("Dispatched Failed! " + this + " to " + this._manager, new Object[0]);
                    this.updateKey();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._redispatched) {
                this._redispatched = false;
                return false;
            }
            this._dispatched = false;
            this.updateKey();
        }
        return true;
    }

    @Override
    public void scheduleIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    @Override
    public void cancelIdle() {
        this._idleTimestamp = 0L;
    }

    public void checkIdleTimestamp(long now) {
        long idleTimestamp = this._idleTimestamp;
        if (idleTimestamp != 0L && this._maxIdleTime > 0 && now > idleTimestamp + (long)this._maxIdleTime) {
            this.idleExpired();
        }
    }

    protected void idleExpired() {
        this._connection.idleExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        if (l == 0 && (header != null && header.hasContent() || buffer != null && buffer.hasContent() || trailer != null && trailer.hasContent())) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        } else {
            this._writable = true;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        if (l == 0 && buffer != null && buffer.hasContent()) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        } else {
            this._writable = true;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadyForDispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return !this._dispatched && !this.getConnection().isSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            try {
                this._readBlocked = true;
                do {
                    if (!this.isOpen()) return true;
                    if (!this._readBlocked) return true;
                    try {
                        this.updateKey();
                        this.wait(timeoutMs >= 0L ? end - now : 10000L);
                    }
                    catch (InterruptedException e) {
                        __log.warn(e);
                    }
                    finally {
                        now = this._selectSet.getNow();
                    }
                } while (!this._readBlocked || timeoutMs <= 0L || now < end);
                boolean bl = false;
                return bl;
            }
            finally {
                this._readBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (!this.isOpen()) throw new EofException();
            if (this.isOutputShutdown()) {
                throw new EofException();
            }
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            try {
                this._writeBlocked = true;
                do {
                    if (!this.isOpen()) return true;
                    if (!this._writeBlocked) return true;
                    if (this.isOutputShutdown()) return true;
                    try {
                        this.updateKey();
                        this.wait(timeoutMs >= 0L ? end - now : 10000L);
                    }
                    catch (InterruptedException e) {
                        __log.warn(e);
                    }
                    finally {
                        now = this._selectSet.getNow();
                    }
                } while (!this._writeBlocked || timeoutMs <= 0L || now < end);
                boolean e = false;
                return e;
            }
            catch (Throwable e) {
                __log.warn(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (!(e instanceof Error)) throw new RuntimeException(e);
                throw (Error)e;
            }
            finally {
                this._writeBlocked = false;
                if (this._idleTimestamp != -1L) {
                    this.scheduleIdle();
                }
            }
        }
    }

    @Override
    public void scheduleWrite() {
        this._writable = false;
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int ops = -1;
            if (this.getChannel().isOpen()) {
                this._interestOps = (!this._socket.isInputShutdown() && (!this._dispatched || this._readBlocked) ? 1 : 0) | (!this._socket.isOutputShutdown() && (!this._writable || this._writeBlocked) ? 4 : 0);
                try {
                    ops = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                }
                catch (Exception e) {
                    this._key = null;
                    __log.ignore(e);
                }
            }
            if (this._interestOps == ops && this.getChannel().isOpen()) {
                return;
            }
        }
        this._selectSet.addChange(this);
        this._selectSet.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel sc = (SelectableChannel)((Object)this.getChannel());
                        if (sc.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception e) {
                                __log.ignore(e);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                this.cancelIdle();
                                if (this._open) {
                                    this._selectSet.destroyEndPoint(this);
                                }
                                this._open = false;
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key != null && this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.cancel();
                }
                this.cancelIdle();
                if (this._open) {
                    this._selectSet.destroyEndPoint(this);
                }
                this._open = false;
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle() {
        block18: {
            boolean dispatched = true;
            try {
                while (dispatched) {
                    try {
                        Connection next;
                        while ((next = this._connection.handle()) != this._connection) {
                            __log.debug("{} replaced {}", next, this._connection);
                            this._connection = next;
                        }
                    }
                    catch (ClosedChannelException e) {
                        __log.ignore(e);
                    }
                    catch (EofException e) {
                        __log.debug("EOF", e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            __log.ignore(e2);
                        }
                    }
                    catch (IOException e) {
                        __log.warn(e.toString(), new Object[0]);
                        __log.debug(e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            __log.ignore(e2);
                        }
                    }
                    catch (Throwable e) {
                        __log.warn("handle failed", e);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            __log.ignore(e2);
                        }
                    }
                    dispatched = !this.undispatch();
                }
                if (!dispatched) break block18;
                boolean bl = dispatched = !this.undispatch();
            }
            catch (Throwable throwable) {
                if (dispatched) {
                    boolean bl = dispatched = !this.undispatch();
                    while (dispatched) {
                        __log.warn("SCEP.run() finally DISPATCHED", new Object[0]);
                        dispatched = !this.undispatch();
                    }
                }
                throw throwable;
            }
            while (dispatched) {
                __log.warn("SCEP.run() finally DISPATCHED", new Object[0]);
                dispatched = !this.undispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            __log.ignore(e);
        }
        finally {
            this.updateKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return "SCEP@" + this.hashCode() + this._channel + "[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",rb=" + this._readBlocked + ",wb=" + this._writeBlocked + "]";
        }
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    @Override
    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

