/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractLifeCycle
implements LifeCycle {
    public static final String STOPPED = "STOPPED";
    public static final String FAILED = "FAILED";
    public static final String STARTING = "STARTING";
    public static final String STARTED = "STARTED";
    public static final String STOPPING = "STOPPING";
    public static final String RUNNING = "RUNNING";
    private final Object _lock = new Object();
    private final int __FAILED = -1;
    private final int __STOPPED = 0;
    private final int __STARTING = 1;
    private final int __STARTED = 2;
    private final int __STOPPING = 3;
    private volatile int _state = 0;
    protected LifeCycle.Listener[] _listeners;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 2 || this._state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Exception e) {
                this.setFailed(e);
                throw e;
            }
            catch (Error e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 3 || this._state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Exception e) {
                this.setFailed(e);
                throw e;
            }
            catch (Error e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    public boolean isRunning() {
        return this._state == 2 || this._state == 1;
    }

    public boolean isStarted() {
        return this._state == 2;
    }

    public boolean isStarting() {
        return this._state == 1;
    }

    public boolean isStopping() {
        return this._state == 3;
    }

    public boolean isStopped() {
        return this._state == 0;
    }

    public boolean isFailed() {
        return this._state == -1;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners = (LifeCycle.Listener[])LazyList.addToArray(this._listeners, listener, LifeCycle.Listener.class);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners = (LifeCycle.Listener[])LazyList.removeFromArray(this._listeners, listener);
    }

    public String getState() {
        switch (this._state) {
            case -1: {
                return FAILED;
            }
            case 1: {
                return STARTING;
            }
            case 2: {
                return STARTED;
            }
            case 3: {
                return STOPPING;
            }
            case 0: {
                return STOPPED;
            }
        }
        return null;
    }

    private void setStarted() {
        Log.debug("STARTED {}", this);
        this._state = 2;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStarted(this);
            }
        }
    }

    private void setStarting() {
        Log.debug("Starting {}", this);
        this._state = 1;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStarting(this);
            }
        }
    }

    private void setStopping() {
        this._state = 3;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStopping(this);
            }
        }
    }

    private void setStopped() {
        Log.debug("STOPPED {}", this);
        this._state = 0;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleStopped(this);
            }
        }
    }

    private void setFailed(Throwable th) {
        Log.warn("FAILED " + this + ": " + th);
        Log.debug(th);
        this._state = -1;
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].lifeCycleFailure(this, th);
            }
        }
    }
}

