/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.util;

import java.net.NetworkInterface;
import java.rmi.server.UID;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIDProvider {
    private static final Logger log = LoggerFactory.getLogger(UIDProvider.class);
    private static final String JVM_UID;
    private static final String HARDWARE_UID;

    private UIDProvider() {
    }

    public static String getJVMUID() {
        return JVM_UID;
    }

    public static String getHardwareUID() {
        return HARDWARE_UID;
    }

    static {
        UID jvmUIDSource = new UID();
        String asString = jvmUIDSource.toString();
        int lastIdx = asString.lastIndexOf(":");
        JVM_UID = asString.substring(0, lastIdx).replaceAll(":", "");
        byte[] address = null;
        boolean noInterfaces = false;
        Enumeration<NetworkInterface> niEnumeration = null;
        try {
            niEnumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            noInterfaces = true;
        }
        if (niEnumeration != null) {
            while (niEnumeration.hasMoreElements()) {
                byte[] addr;
                NetworkInterface ni = niEnumeration.nextElement();
                try {
                    addr = ni.getHardwareAddress();
                }
                catch (Exception e) {
                    continue;
                }
                if (addr == null || addr.length != 6) continue;
                address = addr;
                break;
            }
        }
        if (address == null) {
            log.warn("Could not generate hardware UID{}. Using fallback: JVM UID as hardware UID.", (Object)(noInterfaces ? " (no interfaces)" : ""));
            HARDWARE_UID = JVM_UID;
        } else {
            StringBuilder sb = new StringBuilder();
            for (void var10_12 : address) {
                sb.append(String.format("%02x", (byte)var10_12));
            }
            HARDWARE_UID = sb.toString();
        }
    }
}

