/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(value={"splitChannels", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EqualizeHistTransform
extends BaseImageTransform {
    private int conversionCode;
    private MatVector splitChannels = new MatVector();

    public EqualizeHistTransform() {
        this(new Random(1234L), 6);
    }

    public EqualizeHistTransform(int conversionCode) {
        this(null, conversionCode);
    }

    public EqualizeHistTransform(Random random, int conversionCode) {
        super(random);
        this.conversionCode = conversionCode;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        Mat result = new Mat();
        try {
            if (mat.channels() == 1) {
                opencv_imgproc.equalizeHist((Mat)mat, (Mat)result);
            } else {
                opencv_core.split((Mat)mat, (MatVector)this.splitChannels);
                opencv_imgproc.equalizeHist((Mat)this.splitChannels.get(0L), (Mat)this.splitChannels.get(0L));
                opencv_core.merge((MatVector)this.splitChannels, (Mat)result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        return coordinates;
    }

    public int getConversionCode() {
        return this.conversionCode;
    }

    public MatVector getSplitChannels() {
        return this.splitChannels;
    }

    public void setConversionCode(int conversionCode) {
        this.conversionCode = conversionCode;
    }

    public void setSplitChannels(MatVector splitChannels) {
        this.splitChannels = splitChannels;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualizeHistTransform)) {
            return false;
        }
        EqualizeHistTransform other = (EqualizeHistTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConversionCode() != other.getConversionCode()) {
            return false;
        }
        MatVector this$splitChannels = this.getSplitChannels();
        MatVector other$splitChannels = other.getSplitChannels();
        return !(this$splitChannels == null ? other$splitChannels != null : !this$splitChannels.equals(other$splitChannels));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EqualizeHistTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConversionCode();
        MatVector $splitChannels = this.getSplitChannels();
        result = result * 59 + ($splitChannels == null ? 43 : $splitChannels.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EqualizeHistTransform(conversionCode=" + this.getConversionCode() + ", splitChannels=" + this.getSplitChannels() + ")";
    }
}

