/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util.files;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class UriFromPathIterator
implements Iterator<URI> {
    final Pattern schemaPattern = Pattern.compile("^.*?:/.*");
    private final Iterator<String> paths;

    @Override
    public boolean hasNext() {
        return this.paths.hasNext();
    }

    @Override
    public URI next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        try {
            String s = this.paths.next();
            if (this.schemaPattern.matcher(s).matches()) {
                return new URI(s);
            }
            return new File(s).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public UriFromPathIterator(Iterator<String> paths) {
        this.paths = paths;
    }
}

