/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.writer.impl.csv;

import java.io.IOException;
import java.util.List;
import org.datavec.api.records.writer.impl.FileRecordWriter;
import org.datavec.api.split.partition.PartitionMetaData;
import org.datavec.api.writable.Writable;

public class CSVRecordWriter
extends FileRecordWriter {
    public static final String DEFAULT_DELIMITER = ",";
    private final byte[] delimBytes = ",".getBytes(this.encoding);
    private boolean firstLine = true;

    @Override
    public boolean supportsBatch() {
        return true;
    }

    @Override
    public PartitionMetaData writeBatch(List<List<Writable>> batch) throws IOException {
        for (List<Writable> record : batch) {
            if (record.isEmpty()) continue;
            if (!this.firstLine) {
                this.out.write("\n".getBytes());
            } else {
                this.firstLine = false;
            }
            int count = 0;
            int last = record.size() - 1;
            for (Writable w : record) {
                this.out.write(w.toString().getBytes(this.encoding));
                if (count++ == last) continue;
                this.out.write(this.delimBytes);
            }
            this.out.flush();
        }
        return PartitionMetaData.builder().numRecordsUpdated(batch.size()).build();
    }

    @Override
    public PartitionMetaData write(List<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            if (!this.firstLine) {
                this.out.write("\n".getBytes());
            } else {
                this.firstLine = false;
            }
            int count = 0;
            int last = record.size() - 1;
            for (Writable w : record) {
                this.out.write(w.toString().getBytes(this.encoding));
                if (count++ == last) continue;
                this.out.write(this.delimBytes);
            }
            this.out.flush();
        }
        return PartitionMetaData.builder().numRecordsUpdated(1).build();
    }
}

