/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.model.vulnerability.Vulnerability;
import org.cyclonedx.util.serializer.CustomDateSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class VulnerabilitySerializer
extends StdSerializer<Vulnerability> {
    private final boolean isXml;
    private final Version version;

    public VulnerabilitySerializer(boolean isXml, Version version) {
        this(null, isXml, version);
    }

    public VulnerabilitySerializer(Class<Vulnerability> t, boolean isXml, Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    public void serialize(Vulnerability vulnerability, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createVulnerabilityInfo(vulnerability, (JsonGenerator)xmlGenerator, serializerProvider);
        } else {
            this.createVulnerabilityInfo(vulnerability, jsonGenerator, serializerProvider);
        }
    }

    private void createVulnerabilityInfo(Vulnerability vulnerability, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ToXmlGenerator xmlGenerator;
        jsonGenerator.writeStartObject();
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getBomRef()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "bom-ref")) {
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                xmlGenerator.setNextIsAttribute(true);
                jsonGenerator.writeStringField("bom-ref", vulnerability.getBomRef());
                xmlGenerator.setNextIsAttribute(false);
            } else {
                jsonGenerator.writeStringField("bom-ref", vulnerability.getBomRef());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getId()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "id")) {
            jsonGenerator.writeStringField("id", vulnerability.getId());
        }
        if (vulnerability.getSource() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "source")) {
            jsonGenerator.writeObjectField("source", (Object)vulnerability.getSource());
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getReferences()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "references")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(vulnerability.getReferences(), xmlGenerator, "reference");
            } else {
                jsonGenerator.writeObjectField("references", vulnerability.getReferences());
            }
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getRatings()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "ratings")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(vulnerability.getRatings(), xmlGenerator, "rating");
            } else {
                jsonGenerator.writeObjectField("ratings", vulnerability.getRatings());
            }
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getCwes()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "cwes")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(vulnerability.getCwes(), xmlGenerator, "cwe");
            } else {
                jsonGenerator.writeObjectField("cwes", vulnerability.getCwes());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getDescription()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "description")) {
            jsonGenerator.writeStringField("description", vulnerability.getDescription());
        }
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getDetail()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "detail")) {
            jsonGenerator.writeStringField("detail", vulnerability.getDetail());
        }
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getRecommendation()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "recommendation")) {
            jsonGenerator.writeStringField("recommendation", vulnerability.getRecommendation());
        }
        if (StringUtils.isNotEmpty((CharSequence)vulnerability.getWorkaround()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "workaround")) {
            jsonGenerator.writeStringField("workaround", vulnerability.getWorkaround());
        }
        if (vulnerability.getProofOfConcept() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "proofOfConcept")) {
            jsonGenerator.writeObjectField("proofOfConcept", (Object)vulnerability.getProofOfConcept());
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getAdvisories()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "advisories")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(vulnerability.getAdvisories(), xmlGenerator, "advisories", "advisory");
            } else {
                jsonGenerator.writeObjectField("advisories", vulnerability.getAdvisories());
            }
        }
        if (vulnerability.getCreated() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "created")) {
            jsonGenerator.writeFieldName("created");
            new CustomDateSerializer().serialize(vulnerability.getCreated(), jsonGenerator, serializerProvider);
        }
        if (vulnerability.getPublished() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "published")) {
            jsonGenerator.writeFieldName("published");
            new CustomDateSerializer().serialize(vulnerability.getPublished(), jsonGenerator, serializerProvider);
        }
        if (vulnerability.getUpdated() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "updated")) {
            jsonGenerator.writeFieldName("updated");
            new CustomDateSerializer().serialize(vulnerability.getUpdated(), jsonGenerator, serializerProvider);
        }
        if (vulnerability.getRejected() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "rejected")) {
            jsonGenerator.writeFieldName("rejected");
            new CustomDateSerializer().serialize(vulnerability.getRejected(), jsonGenerator, serializerProvider);
        }
        if (vulnerability.getCredits() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "credits")) {
            jsonGenerator.writeObjectField("credits", (Object)vulnerability.getCredits());
        }
        this.parseTools(vulnerability, jsonGenerator);
        if (vulnerability.getAnalysis() != null && SerializerUtils.shouldSerializeField(vulnerability, this.version, "analysis")) {
            jsonGenerator.writeObjectField("analysis", (Object)vulnerability.getAnalysis());
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getAffects()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "affects")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(vulnerability.getAffects(), xmlGenerator, "affects", "target");
            } else {
                jsonGenerator.writeObjectField("affects", vulnerability.getAffects());
            }
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getProperties()) && SerializerUtils.shouldSerializeField(vulnerability, this.version, "properties")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                xmlGenerator.writeFieldName("properties");
                xmlGenerator.writeStartObject();
                for (Property property : vulnerability.getProperties()) {
                    xmlGenerator.writeObjectField("property", (Object)property);
                }
                xmlGenerator.writeEndObject();
            } else {
                jsonGenerator.writeObjectField("properties", vulnerability.getProperties());
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void parseTools(Vulnerability vulnerability, JsonGenerator jsonGenerator) throws IOException {
        ToolInformation choice;
        if (this.version.getVersion() >= Version.VERSION_15.getVersion() && (choice = vulnerability.getToolChoice()) != null && (CollectionUtils.isNotEmpty(choice.getComponents()) || CollectionUtils.isNotEmpty(choice.getServices()))) {
            jsonGenerator.writeFieldName("tools");
            jsonGenerator.writeStartObject();
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                if (CollectionUtils.isNotEmpty(choice.getComponents())) {
                    this.writeArrayFieldXML(choice.getComponents(), (ToXmlGenerator)jsonGenerator, "component");
                }
                if (CollectionUtils.isNotEmpty(choice.getServices())) {
                    this.writeArrayFieldXML(choice.getServices(), (ToXmlGenerator)jsonGenerator, "service");
                }
            } else {
                if (CollectionUtils.isNotEmpty(choice.getComponents())) {
                    this.writeArrayFieldJSON(jsonGenerator, "components", choice.getComponents());
                }
                if (CollectionUtils.isNotEmpty(choice.getServices())) {
                    this.writeArrayFieldJSON(jsonGenerator, "services", choice.getServices());
                }
            }
            jsonGenerator.writeEndObject();
            return;
        }
        if (CollectionUtils.isNotEmpty(vulnerability.getTools())) {
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                this.writeArrayFieldXML(vulnerability.getTools(), (ToXmlGenerator)jsonGenerator, "tool");
            } else {
                this.writeArrayFieldJSON(jsonGenerator, "tools", vulnerability.getTools());
            }
        }
    }

    private <T> void writeArrayFieldJSON(JsonGenerator jsonGenerator, String fieldName, List<T> items) throws IOException {
        if (items != null) {
            jsonGenerator.writeArrayFieldStart(fieldName);
            for (T item : items) {
                jsonGenerator.writeObject(item);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private <T> void writeArrayFieldXML(List<T> items, ToXmlGenerator xmlGenerator, String fieldName) throws IOException {
        this.writeArrayFieldXML(items, xmlGenerator, fieldName + "s", fieldName);
    }

    private <T> void writeArrayFieldXML(List<T> items, ToXmlGenerator xmlGenerator, String wrapperName, String elementName) throws IOException {
        if (CollectionUtils.isNotEmpty(items)) {
            xmlGenerator.writeFieldName(wrapperName);
            xmlGenerator.writeStartObject();
            for (T item : items) {
                xmlGenerator.writeFieldName(elementName);
                xmlGenerator.writeObject(item);
            }
            xmlGenerator.writeEndObject();
        }
    }

    public Class<Vulnerability> handledType() {
        return Vulnerability.class;
    }
}

