/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.model.formulation.common.OutputType;
import org.cyclonedx.util.serializer.EnvironmentVarsSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class OutputTypeSerializer
extends StdSerializer<OutputType> {
    private final boolean isXml;

    public OutputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public OutputTypeSerializer(Class<OutputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(OutputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createOutputChoiceXml(value, xmlGenerator, serializerProvider);
        } else {
            this.createOutputChoiceJson(value, jsonGenerator, serializerProvider);
        }
    }

    private void createOutputChoiceJson(OutputType output, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (output.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)output.getResource());
        } else if (output.getEnvironmentVars() != null) {
            new EnvironmentVarsSerializer(this.isXml).serialize(output.getEnvironmentVars(), jsonGenerator, serializerProvider);
        } else if (output.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)output.getData());
        }
        SerializerUtils.writeField(jsonGenerator, "type", (Object)output.getType());
        SerializerUtils.writeField(jsonGenerator, "source", output.getSource());
        SerializerUtils.writeField(jsonGenerator, "target", output.getTarget());
        SerializerUtils.writeField(jsonGenerator, "properties", output.getProperties());
        jsonGenerator.writeEndObject();
    }

    private void createOutputChoiceXml(OutputType output, ToXmlGenerator xmlGenerator, SerializerProvider serializerProvider) throws IOException {
        xmlGenerator.writeStartObject();
        if (output.getResource() != null) {
            xmlGenerator.writeFieldName("resource");
            xmlGenerator.writeObject((Object)output.getResource());
        } else if (output.getEnvironmentVars() != null) {
            new EnvironmentVarsSerializer(this.isXml).serialize(output.getEnvironmentVars(), (JsonGenerator)xmlGenerator, serializerProvider);
        } else if (output.getData() != null) {
            xmlGenerator.writeFieldName("data");
            xmlGenerator.writeObject((Object)output.getData());
        }
        if (output.getType() != null) {
            xmlGenerator.writeFieldName("type");
            xmlGenerator.writeObject((Object)output.getType());
        }
        if (output.getSource() != null) {
            xmlGenerator.writeFieldName("source");
            xmlGenerator.writeObject((Object)output.getSource());
        }
        if (output.getTarget() != null) {
            xmlGenerator.writeFieldName("target");
            xmlGenerator.writeObject((Object)output.getTarget());
        }
        if (CollectionUtils.isNotEmpty(output.getProperties())) {
            xmlGenerator.writeFieldName("properties");
            xmlGenerator.writeObject(output.getProperties());
        }
        xmlGenerator.writeEndObject();
    }

    public Class<OutputType> handledType() {
        return OutputType.class;
    }
}

