/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.Iterator;
import java.util.List;
import org.cyclonedx.Version;
import org.cyclonedx.model.Component;
import org.cyclonedx.util.serializer.AuthorsSerializer;

public class AuthorsBeanSerializerModifier
extends BeanSerializerModifier {
    private final Version version;

    public AuthorsBeanSerializerModifier(Version version) {
        this.version = version;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (Component.class.isAssignableFrom(beanDesc.getBeanClass())) {
            Iterator<BeanPropertyWriter> iterator = beanProperties.iterator();
            while (iterator.hasNext()) {
                BeanPropertyWriter writer = iterator.next();
                if (!"authors".equals(writer.getName())) continue;
                if (this.version.getVersion() < Version.VERSION_16.getVersion()) {
                    iterator.remove();
                    break;
                }
                AuthorsSerializer serializer = new AuthorsSerializer();
                writer.assignSerializer((JsonSerializer)serializer);
                break;
            }
        }
        return beanProperties;
    }
}

