/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.vulnerability.Vulnerability;
import org.cyclonedx.util.TimestampUtils;
import org.cyclonedx.util.ToolsJsonParser;
import org.cyclonedx.util.deserializer.AffectsDeserializer;
import org.cyclonedx.util.deserializer.DeserializerUtils;
import org.cyclonedx.util.deserializer.PropertiesDeserializer;

public class VulnerabilityDeserializer
extends JsonDeserializer<List<Vulnerability>> {
    private final PropertiesDeserializer propertiesDeserializer = new PropertiesDeserializer();
    private final AffectsDeserializer affectsDeserializer = new AffectsDeserializer();

    public List<Vulnerability> deserialize(JsonParser parser, DeserializationContext context) {
        try {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            return this.parseVulnerabilities(node.has("vulnerability") ? node.get("vulnerability") : node, parser, context);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Vulnerability> parseVulnerabilities(JsonNode node, JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = this.getMapper(jsonParser);
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, mapper);
        for (JsonNode vulnerabilityNode : nodes) {
            vulnerabilities.add(this.parseVulnerability(vulnerabilityNode, jsonParser, ctxt, mapper));
        }
        return vulnerabilities;
    }

    private Vulnerability parseVulnerability(JsonNode node, JsonParser jsonParser, DeserializationContext ctxt, ObjectMapper mapper) throws IOException {
        String workaround;
        String recommendation;
        String detail;
        String description;
        String id;
        String bomRef;
        JsonParser vulnerabilityParser = node.traverse(jsonParser.getCodec());
        vulnerabilityParser.nextToken();
        Vulnerability vulnerability = new Vulnerability();
        if (node.has("bom-ref") && StringUtils.isNotEmpty((CharSequence)(bomRef = node.get("bom-ref").asText()))) {
            vulnerability.setBomRef(bomRef);
        }
        if (node.has("id") && StringUtils.isNotEmpty((CharSequence)(id = node.get("id").asText()))) {
            vulnerability.setId(id);
        }
        if (node.has("description") && StringUtils.isNotEmpty((CharSequence)(description = node.get("description").asText()))) {
            vulnerability.setDescription(description);
        }
        if (node.has("detail") && StringUtils.isNotEmpty((CharSequence)(detail = node.get("detail").asText()))) {
            vulnerability.setDetail(detail);
        }
        if (node.has("recommendation") && StringUtils.isNotEmpty((CharSequence)(recommendation = node.get("recommendation").asText()))) {
            vulnerability.setRecommendation(recommendation);
        }
        if (node.has("workaround") && StringUtils.isNotEmpty((CharSequence)(workaround = node.get("workaround").asText()))) {
            vulnerability.setWorkaround(workaround);
        }
        if (node.has("source")) {
            Vulnerability.Source source = (Vulnerability.Source)mapper.convertValue((Object)node.get("source"), Vulnerability.Source.class);
            vulnerability.setSource(source);
        }
        if (node.has("references")) {
            JsonNode referencesNode = node.get("references");
            if (referencesNode.isArray()) {
                List references = (List)mapper.convertValue((Object)node.get("references"), (TypeReference)new TypeReference<List<Vulnerability.Reference>>(){});
                vulnerability.setReferences(references);
            } else if (referencesNode.has("reference")) {
                JsonNode referenceNode = referencesNode.get("reference");
                if (referenceNode.isArray()) {
                    List references = (List)mapper.convertValue((Object)referenceNode, (TypeReference)new TypeReference<List<Vulnerability.Reference>>(){});
                    vulnerability.setReferences(references);
                } else {
                    vulnerability.addReference((Vulnerability.Reference)mapper.convertValue((Object)referenceNode, Vulnerability.Reference.class));
                }
            }
        }
        if (node.has("ratings")) {
            JsonNode ratingsNode = node.get("ratings");
            if (ratingsNode.isArray()) {
                List ratings = (List)mapper.convertValue((Object)node.get("ratings"), (TypeReference)new TypeReference<List<Vulnerability.Rating>>(){});
                vulnerability.setRatings(ratings);
            } else if (ratingsNode.has("rating")) {
                JsonNode ratingNode = ratingsNode.get("rating");
                if (ratingNode.isArray()) {
                    List ratings = (List)mapper.convertValue((Object)ratingNode, (TypeReference)new TypeReference<List<Vulnerability.Rating>>(){});
                    vulnerability.setRatings(ratings);
                } else {
                    vulnerability.addRating((Vulnerability.Rating)mapper.convertValue((Object)ratingNode, Vulnerability.Rating.class));
                }
            }
        }
        if (node.has("cwes")) {
            JsonNode cwesNode = node.get("cwes");
            if (cwesNode.isArray()) {
                List codes = (List)mapper.convertValue((Object)node.get("cwes"), (TypeReference)new TypeReference<List<Integer>>(){});
                vulnerability.setCwes(codes);
            } else if (cwesNode.has("cwe")) {
                JsonNode cweNode = cwesNode.get("cwe");
                if (cweNode.isArray()) {
                    List codes = (List)mapper.convertValue((Object)cweNode, (TypeReference)new TypeReference<List<Integer>>(){});
                    vulnerability.setCwes(codes);
                } else {
                    vulnerability.addCwe(cweNode.asInt());
                }
            }
        }
        if (node.has("advisories")) {
            JsonNode advisoriesNode = node.get("advisories");
            if (advisoriesNode.isArray()) {
                List advisories = (List)mapper.convertValue((Object)node.get("advisories"), (TypeReference)new TypeReference<List<Vulnerability.Advisory>>(){});
                vulnerability.setAdvisories(advisories);
            } else if (advisoriesNode.has("advisory")) {
                JsonNode advisoryNode = advisoriesNode.get("advisory");
                if (advisoryNode.isArray()) {
                    List advisories = (List)mapper.convertValue((Object)advisoryNode, (TypeReference)new TypeReference<List<Vulnerability.Advisory>>(){});
                    vulnerability.setAdvisories(advisories);
                } else {
                    vulnerability.addAdvisory((Vulnerability.Advisory)mapper.convertValue((Object)advisoryNode, Vulnerability.Advisory.class));
                }
            }
        }
        if (node.has("created")) {
            vulnerability.setCreated(TimestampUtils.parseTimestamp(node.get("created").textValue()));
        }
        if (node.has("published")) {
            vulnerability.setPublished(TimestampUtils.parseTimestamp(node.get("published").textValue()));
        }
        if (node.has("updated")) {
            vulnerability.setUpdated(TimestampUtils.parseTimestamp(node.get("updated").textValue()));
        }
        if (node.has("rejected")) {
            vulnerability.setRejected(TimestampUtils.parseTimestamp(node.get("rejected").textValue()));
        }
        if (node.has("credits")) {
            this.parseCredits(node.get("credits"), vulnerability, mapper);
        }
        if (node.has("analysis")) {
            this.parseAnalysis(node.get("analysis"), vulnerability, mapper);
        }
        if (node.has("affects")) {
            JsonParser affectsParser = node.get("affects").traverse(jsonParser.getCodec());
            affectsParser.nextToken();
            Object affects = this.affectsDeserializer.deserialize(affectsParser, ctxt);
            vulnerability.setAffects((List<Vulnerability.Affect>)affects);
        }
        if (node.has("properties")) {
            JsonParser propertiesParser = node.get("properties").traverse(jsonParser.getCodec());
            propertiesParser.nextToken();
            Object properties = this.propertiesDeserializer.deserialize(propertiesParser, ctxt);
            vulnerability.setProperties((List<Property>)properties);
        }
        if (node.has("tools")) {
            ToolsJsonParser toolsParser = new ToolsJsonParser(node, jsonParser, ctxt);
            vulnerability.setTools(toolsParser.getTools());
            vulnerability.setToolChoice(toolsParser.getToolInformation());
        }
        return vulnerability;
    }

    private void parseAnalysis(JsonNode analysisNode, Vulnerability vulnerability, ObjectMapper mapper) {
        if (analysisNode != null) {
            JsonNode responsesNode;
            String detail;
            Vulnerability.Analysis analysis = new Vulnerability.Analysis();
            if (analysisNode.has("state")) {
                analysis.setState((Vulnerability.Analysis.State)((Object)mapper.convertValue((Object)analysisNode.get("state"), Vulnerability.Analysis.State.class)));
            }
            if (analysisNode.has("justification")) {
                analysis.setJustification((Vulnerability.Analysis.Justification)((Object)mapper.convertValue((Object)analysisNode.get("justification"), Vulnerability.Analysis.Justification.class)));
            }
            if (analysisNode.has("detail") && StringUtils.isNotEmpty((CharSequence)(detail = analysisNode.get("detail").asText()))) {
                analysis.setDetail(detail);
            }
            if (analysisNode.has("firstIssued")) {
                analysis.setFirstIssued(TimestampUtils.parseTimestamp(analysisNode.get("firstIssued").textValue()));
            }
            if (analysisNode.has("lastUpdated")) {
                analysis.setLastUpdated(TimestampUtils.parseTimestamp(analysisNode.get("lastUpdated").textValue()));
            }
            if (analysisNode.has("response")) {
                responsesNode = analysisNode.get("response");
                if (responsesNode.isArray()) {
                    List responses = (List)mapper.convertValue((Object)responsesNode, (TypeReference)new TypeReference<List<Vulnerability.Analysis.Response>>(){});
                    analysis.setResponses(responses);
                }
            } else if (analysisNode.has("responses") && (responsesNode = analysisNode.get("responses")).has("response")) {
                JsonNode responseNode = responsesNode.get("response");
                if (responseNode.isArray()) {
                    List responses = (List)mapper.convertValue((Object)responseNode, (TypeReference)new TypeReference<List<Vulnerability.Analysis.Response>>(){});
                    analysis.setResponses(responses);
                } else if (responseNode.isTextual()) {
                    Vulnerability.Analysis.Response response = Vulnerability.Analysis.Response.fromString(responseNode.asText());
                    analysis.addResponse(response);
                }
            }
            vulnerability.setAnalysis(analysis);
        }
    }

    private void parseCredits(JsonNode creditsNode, Vulnerability vulnerability, ObjectMapper mapper) {
        Vulnerability.Credits credits = new Vulnerability.Credits();
        if (creditsNode.has("organizations")) {
            this.parseOrganizations(creditsNode.get("organizations"), credits, mapper);
        }
        if (creditsNode.has("individuals")) {
            this.parseIndividuals(creditsNode.get("individuals"), credits, mapper);
        }
        vulnerability.setCredits(credits);
    }

    private void parseOrganizations(JsonNode organizationsNode, Vulnerability.Credits credits, ObjectMapper mapper) {
        if (organizationsNode != null) {
            if (organizationsNode.isArray()) {
                List organizations = (List)mapper.convertValue((Object)organizationsNode, (TypeReference)new TypeReference<List<OrganizationalEntity>>(){});
                credits.setOrganizations(organizations);
            } else if (organizationsNode.isObject()) {
                OrganizationalEntity organization = (OrganizationalEntity)mapper.convertValue((Object)organizationsNode.get("organization"), OrganizationalEntity.class);
                credits.addOrganization(organization);
            }
        }
    }

    private void parseIndividuals(JsonNode individualsNode, Vulnerability.Credits credits, ObjectMapper mapper) {
        if (individualsNode != null) {
            if (individualsNode.isArray()) {
                List individuals = (List)mapper.convertValue((Object)individualsNode, (TypeReference)new TypeReference<List<OrganizationalContact>>(){});
                credits.setIndividuals(individuals);
            } else if (individualsNode.isObject()) {
                OrganizationalContact individual = (OrganizationalContact)mapper.convertValue((Object)individualsNode.get("individual"), OrganizationalContact.class);
                credits.addIndividual(individual);
            }
        }
    }

    private ObjectMapper getMapper(JsonParser jsonParser) {
        if (jsonParser.getCodec() instanceof ObjectMapper) {
            return (ObjectMapper)jsonParser.getCodec();
        }
        return new ObjectMapper();
    }
}

