/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.deserializer.DeserializerUtils;
import org.cyclonedx.util.deserializer.ToolDeserializer;

public class ToolsDeserializer
extends JsonDeserializer<List<Tool>> {
    private final ToolDeserializer toolDeserializer = new ToolDeserializer();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<Tool> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.parseTools(node.has("tool") ? node.get("tool") : node, jsonParser, ctxt);
    }

    private List<Tool> parseTools(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Tool> tools = new ArrayList<Tool>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, this.objectMapper);
        for (JsonNode toolNode : nodes) {
            tools.add(this.parseTool(toolNode, p, ctxt));
        }
        return tools;
    }

    private Tool parseTool(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonParser toolParser = node.traverse(p.getCodec());
        toolParser.nextToken();
        return this.toolDeserializer.deserialize(toolParser, ctxt);
    }
}

