/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.metadata.ToolInformation;

public class ToolInformationDeserializer
extends JsonDeserializer<ToolInformation> {
    private final ObjectMapper mapper = new ObjectMapper();

    public ToolInformation deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.parseToolInformation(node);
    }

    private ToolInformation parseToolInformation(JsonNode toolsNode) {
        ToolInformation toolInformation = new ToolInformation();
        if (toolsNode.has("components")) {
            this.parseComponents(toolsNode.get("components"), toolInformation);
        }
        if (toolsNode.has("services")) {
            this.parseServices(toolsNode.get("services"), toolInformation);
        }
        return toolInformation;
    }

    private void parseComponents(JsonNode componentsNode, ToolInformation toolInformation) {
        if (componentsNode != null) {
            if (componentsNode.isArray()) {
                List components = (List)this.mapper.convertValue((Object)componentsNode, (TypeReference)new TypeReference<List<Component>>(){});
                toolInformation.setComponents(components);
            } else if (componentsNode.isObject() && componentsNode.has("component")) {
                JsonNode componentNode = componentsNode.get("component");
                if (componentNode.isArray()) {
                    List components = (List)this.mapper.convertValue((Object)componentNode, (TypeReference)new TypeReference<List<Component>>(){});
                    toolInformation.setComponents(components);
                } else if (componentNode.isObject()) {
                    Component component = (Component)this.mapper.convertValue((Object)componentNode, Component.class);
                    toolInformation.getComponents().add(component);
                }
            }
        }
    }

    private void parseServices(JsonNode servicesNode, ToolInformation toolInformation) {
        if (servicesNode != null) {
            if (servicesNode.isArray()) {
                List services = (List)this.mapper.convertValue((Object)servicesNode, (TypeReference)new TypeReference<List<Service>>(){});
                toolInformation.setServices(services);
            } else if (servicesNode.isObject() && servicesNode.has("service")) {
                JsonNode serviceNode = servicesNode.get("service");
                if (serviceNode.isArray()) {
                    List services = (List)this.mapper.convertValue((Object)servicesNode, (TypeReference)new TypeReference<List<Service>>(){});
                    toolInformation.setServices(services);
                } else if (serviceNode.isObject()) {
                    Service service = (Service)this.mapper.convertValue((Object)servicesNode, Service.class);
                    toolInformation.getServices().add(service);
                }
            }
        }
    }
}

