/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.formulation.common.EnvironmentVars;

public class EnvironmentVarsDeserializer
extends StdDeserializer<EnvironmentVars> {
    public EnvironmentVarsDeserializer() {
        this(null);
    }

    public EnvironmentVarsDeserializer(Class<?> vc) {
        super(vc);
    }

    public EnvironmentVars deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        EnvironmentVars environmentVars = new EnvironmentVars();
        ArrayList<Object> choices = new ArrayList<Object>();
        if (node.isObject()) {
            this.processObject(node, choices);
        } else if (node.isArray()) {
            for (JsonNode n : node) {
                this.processObject(n, choices);
            }
        } else {
            choices.add(node.asText());
        }
        environmentVars.setChoices(choices);
        return environmentVars;
    }

    private void processObject(JsonNode node, List<Object> choices) {
        if (node.has("environmentVar") && node.has("value")) {
            JsonNode envVarNode = node.get("environmentVar");
            Property environmentVar = this.createProperty(envVarNode);
            choices.add(environmentVar);
            choices.add(node.get("value").asText());
        } else if (node.has("value")) {
            if (node.has("name")) {
                Property environmentVar = this.createProperty(node);
                choices.add(environmentVar);
            } else {
                choices.add(node.get("value").asText());
            }
        } else if (node.has("environmentVar")) {
            JsonNode envVarNode = node.get("environmentVar");
            Property environmentVar = this.createProperty(envVarNode);
            choices.add(environmentVar);
        } else if (node.isTextual()) {
            choices.add(node.asText());
        }
    }

    private Property createProperty(JsonNode envVarNode) {
        Property prop = new Property();
        if (envVarNode.has("name")) {
            String name = envVarNode.get("name").asText();
            prop.setName(name);
        }
        if (envVarNode.has("")) {
            value = envVarNode.get("").asText();
            prop.setValue(value);
        } else if (envVarNode.has("value")) {
            value = envVarNode.get("value").asText();
            prop.setValue(value);
        }
        return prop;
    }
}

